/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of courses in grid
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormCourseGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookingcoursegrid',
    border: true,
    multiSelect: true,
    columns: [{
        header: getCommonTranslation('COURSE_NAME'), //Course Name
        dataIndex: 'id',
        flex: .3,        
        hidden:true
    },{
        header: getCommonTranslation('COURSE_NAME'), //Course Name
        dataIndex: 'code',
        flex: .3
    }],
    initComponent: function() {
    	var this$ = this;
        Ext.apply(this$, {
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseListStore'),
            viewConfig: {
                stripeRows: CONSTANTS.STRIPEROWS,
                plugins: {
                    ptype: 'gridviewdragdrop'
                },
                loadMask: false,
                listeners: {
                    drop: function(node, data, dropRec, dropPosition) {
                    	var currGrid,targetGrid,countOfTargetGrid,countOfCurrGrid,me=this;
                    	if(data && data.view){
                    		currGrid = data.view.ownerCt;
                    	}
                        targetGrid = me.ownerCt;
                        if(targetGrid && targetGrid.getStore()){
                        	countOfTargetGrid = targetGrid.getStore().getCount(); 
                        }
                        if(currGrid && currGrid.getStore()){
                        	countOfCurrGrid = currGrid.getStore().getCount(); 
                        }
                        if( targetGrid.down('#totalRecordDisplayField')){
                        	 targetGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfTargetGrid);
                        }
                        if(currGrid.down('#totalRecordDisplayField')){
                        	currGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfCurrGrid)
                        }
                    }
                }
            },
            tbar: [{
                xtype: 'textfield',
                itemId: 'txtName',
                hidden: (this$.selectedCourseGrid)?true:false,
                fieldLabel: getCommonTranslation('COURSE_NAME') //Course Name
            },{
        	    xtype: 'button',
        	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
        	    itemId: 'btnViewCalendar',
        	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
        	}]
        });
        this$.callParent(arguments);
    },
    /*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('EMPTY_COURSE_MESSAGE'),
            displayInfo: true
        }]
    }],*/
    listeners: {
        viewready: function(grid) {
            var view = grid.view;

            grid.tip = Ext.create('Ext.tip.ToolTip', {
                target: view.el,
                delegate: '.x-grid-cell',
                trackMouse: true,
                renderTo: Ext.getBody(),
                listeners: {
                    beforeshow: function updateTipBody(tip) {
                        tip.update(getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')); //Please select a record for drag and drop
                    }
                }
            });

        }
    }
});