/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of equipments in grid 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormEquipmentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookingequipmentgrid',
    border: true,
    multiSelect: true,
    columns: [{
        header: getCommonTranslation('CODE'), //Code
        dataIndex: 'code',
        flex: .2
    }, {
        header: getCommonTranslation('NAME'), //Name
        dataIndex: 'name',
        flex: .3
    }, {
        header: getCommonTranslation('TYPE'), //Type
        dataIndex: 'type',
        flex: .2
    }, {
        header: getCommonTranslation('STATUS'), //Status        
        dataIndex: 'availabilityStatus',
        flex: .2,
        hidden:true,
        renderer: function(value) {
        	var status= value;
			if(status.toLowerCase()===(getCommonTranslation('AVAILABLE')).toLowerCase()){
		    	return '<div style="color:green;">('+getCommonTranslation('AVAILABLE')+')</div>';
		    }else if(status.toLowerCase()===(getCommonTranslation('BOOKED')).toLowerCase()){
		    	return '<div style="color:red;">('+getCommonTranslation('BOOKED')+')</div>';
		    }
		    /*else if(status===getCommonTranslation('PARTLY_AVAILABLE')){
		    	return '<div style="color:yellow;">('+getCommonTranslation('PARTLY_AVAILABLE')+')</div>';
		    }*/
        }
    }],
    initComponent: function() {
    	var this$ = this;
    	Ext.apply(this$, {
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.EquipmentListStore'),
            viewConfig: {
            	stripeRows: CONSTANTS.STRIPEROWS,
            	plugins: {
            		ptype: 'gridviewdragdrop'
            	},  
            	loadMask: false,
            	listeners: {
            		drop: function(node, data, dropRec, dropPosition) {
            			var currGrid,targetGrid,countOfTargetGrid,countOfCurrGrid,me=this;
            			if(data && data.view){
            				currGrid = data.view.ownerCt;
            			}
            			targetGrid = me.ownerCt;
            			if(targetGrid && targetGrid.getStore()){
            				countOfTargetGrid = targetGrid.getStore().getCount(); 
            			}
            			if(currGrid && currGrid.getStore()){
            				countOfCurrGrid = currGrid.getStore().getCount(); 
            			}
            			if( targetGrid.down('#totalRecordDisplayField')){
            				targetGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfTargetGrid);
            			}
            			if(currGrid.down('#totalRecordDisplayField')){
            				currGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfCurrGrid)
            			}
            		}
            	}
            },
            tbar: [{
                xtype: 'customcombobox',
                itemId: 'cmbResourceType',
                //store: 'facilitiesresources.resourcebooking.ResourceTypeStore',
                //		fieldLabel:getCommonTranslation('RESOURCE_TYPE'),//Resource Type
                valueField: 'id',
                displayField: 'value',
                width:'20%',
                editable: false,
                value:'',
                queryMode: 'local',
                hidden: (this$.selectedEquipmentGrid)?true:false,
                triggerAcation: 'all',
                fourceSelection: true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore');
                        combo.bindStore(store);
                    }
                }
            },{
        	    xtype: 'button',
        	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
        	    itemId: 'btnViewCalendar',
        	    text:getCommonTranslation('VIEW_CALENDAR')//View Calendar
        	}]
        });
    	this$.callParent(arguments);
    },
    
	/*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('EMPTY_EQUIPMENT_MESSAGE'),
            displayInfo: true
        }]
    }],*/
    listeners: {
        viewready: function(grid) {
            var view = grid.view;

            grid.tip = Ext.create('Ext.tip.ToolTip', {
                target: view.el,
                delegate: '.x-grid-cell',
                trackMouse: true,
                renderTo: Ext.getBody(),
                listeners: {
                    beforeshow: function updateTipBody(tip) {
                        tip.update(getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')); //Please select a record for drag and drop
                    }
                }
            });

        }
    }
});
