/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of programs in grid
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.resourcebookingprogramgrid',
	border:true,	
	multiSelect: true,
	columns :[{
		header : getCommonTranslation('PROGRAM_NAME'), //Program Name
		dataIndex : 'program',		
		flex:.2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
	},{
		header : getCommonTranslation('BATCH'),//Batch
		dataIndex : 'batch',		
		flex:.2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
	},{
		header : getCommonTranslation('PERIOD'),//Batch
		dataIndex : 'period',		
		flex:.2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
	},{
		header : getCommonTranslation('SECTION'),//Section
		dataIndex : 'section',		
		flex:.2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
	}],	
	initComponent: function() {
		var this$ = this;
        Ext.apply(this$, {
            store:Ext.create('Academia.store.facilitiesresources.resourcebooking.ProgramListStore'),
        	viewConfig : {
        		stripeRows : CONSTANTS.STRIPEROWS,
        		plugins: {
                    ptype: 'gridviewdragdrop'
        		},
            loadMask: false,
            listeners: {
                drop: function(node, data, dropRec, dropPosition) {
                	var currGrid,targetGrid,countOfTargetGrid,countOfCurrGrid,me=this;
                	if(data && data.view){
                		currGrid = data.view.ownerCt;
                	}
                    targetGrid = me.ownerCt;
                    if(targetGrid && targetGrid.getStore()){
                    	countOfTargetGrid = targetGrid.getStore().getCount(); 
                    }
                    if(currGrid && currGrid.getStore()){
                    	countOfCurrGrid = currGrid.getStore().getCount(); 
                    }
                    if( targetGrid.down('#totalRecordDisplayField')){
                    	 targetGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfTargetGrid);
                    }
                    if(currGrid.down('#totalRecordDisplayField')){
                    	currGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfCurrGrid)
                    }
                }
            }
        	},
        	tbar : [/*{
        		xtype:'textfield',
        		itemId:'txtName',
        		hidden: (this$.selectedProgramGrid)?true:false,
        		width:'15%',
        		emptyText:getCommonTranslation('PLACE_HOLDER_EMPTY_TEXT') //Program Name
        	}*/{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTerm',
				hidden: (this$.selectedProgramGrid)?true:false,
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable:false,
				width:'10%',
				matchFieldWidth : false,
				listConfig : {
        			width:250
        		},
				forceSelection : true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermStore');
						combo.bindStore(store)
					}
				}
			},{
        		xtype:'customcombobox',
        		itemId:'cmbProgram', 
        		hidden: (this$.selectedProgramGrid)?true:false,
        		store:'facilitiesresources.resourcebooking.AllProgramsStore',
//        		fieldLabel:getCommonTranslation('PROGRAM'),//Program
        		valueField : 'id',
        		displayField : 'value',				
        		width:'15%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:250
        		},
        		editable:false,
        		queryMode: 'local',
        		triggerAcation:'all',
        		emptyText:getCommonTranslation('PROGRAM'),
        		fourceSelection:true		
        	},{
        		xtype:'customcombobox',
        		itemId:'cmbBatch', 
        		hidden: (this$.selectedProgramGrid)?true:false,
        		store:'facilitiesresources.resourcebooking.AllBatchesStore',
//        		fieldLabel:getCommonTranslation('BATCH'),//Batch
        		valueField : 'id',
        		displayField : 'value',				
        		width:'10%',
        		emptyText:getCommonTranslation('BATCH'),
        		matchFieldWidth : false,
        		listConfig : {
        			width:250
        		},
        		editable:false,
        		disabled:true,
        		queryMode: 'local',
        		triggerAcation:'all',
        		fourceSelection:true		
        	},{
                xtype: 'customcombobox',
                name: 'period',
                itemId: 'cmbPeriod',	 
                hidden: (this$.selectedProgramGrid)?true:false,
                 //Select Period  
                store: 'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
                valueField: 'id',
                emptyText:getCommonTranslation('PERIOD'),
                displayField: 'value',
                width:'10%',
                matchFieldWidth : false,
                listConfig : {
        			width:250
        		},
                editable: false,
                disabled:true,
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true         
           },{
        		xtype:'customcombobox',
        		itemId:'cmbSection', 
        		hidden: (this$.selectedProgramGrid)?true:false,
        		store:'facilitiesresources.resourcebooking.AllSectionsStore',
//        		fieldLabel:getCommonTranslation('SECTION'),//Section
        		emptyText:getCommonTranslation('SECTION'),
        		valueField : 'id',
        		displayField : 'value',				
        		width:'10%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:250
        		},
        		editable:false,
        		disabled:true,
                queryMode: 'local',
        		triggerAcation:'all',
        		fourceSelection:true		
        	},{
        	    xtype: 'button',
        	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
        	    itemId: 'btnViewCalendar',
        	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
        	}]
        });
        this$.callParent(arguments);
    },
	/*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('EMPTY_PROGRAM_MESSAGE'),
            displayInfo: true
        }]
    }],*/
		listeners: {
	        viewready: function (grid) {
	            var view = grid.view;
	            
	            grid.tip = Ext.create('Ext.tip.ToolTip', {
	                target: view.el,
	                delegate: '.x-grid-cell',
	                trackMouse: true,
	                renderTo: Ext.getBody(),
	                listeners: {
	                    beforeshow: function updateTipBody(tip) {
	                    	tip.update(getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')); //Please select a record for drag and drop
	                    }
	                }
	            });

	        }
	    }
});