/*
 *@author Deepak Sharma
 * 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingFormLayout', {
    extend: 'Academia.view.common.IdGeneratorForm',
    alias: 'widget.employeeresourcebookingformlayout',
    //cls: 'panelNoSpace',
    formCode:'ResourceBookingFormLayout',
    autoScroll: true,
    frame: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    itemId: 'employeeresourcebookingform',
    title: getCommonTranslation('EVENT_DETAILS'),
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    minWidth:800,
        items: [{
            layout: {
                type: 'hbox'
            },
            width: 850,
            items: [{
                flex: .2,
                defaults: {
                	width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'hidden',
                    itemId: 'versionId_hidden_field',
                    name: 'version'
                },{
                    xtype: 'hidden',
                    itemId: 'eventCalendarId',
                    name: 'eventCalendarId'
                },{       
                	xtype: 'hidden',
                    itemId: 'ID',
                    name: 'id'
                }, {
                    xtype: 'textfield',
                    name: 'resourceCategoryCode',
                    itemId: 'resourceCategoryCode',
                    fieldLabel: getCommonTranslation('EVENT_ID'), //Booking ID
                    //emptyText: getCommonTranslation('ID_AUTOGENERATE'),
                    maxLength: 10,
                    readOnly: true
                    ////allowBlank: false		
                },{
                    xtype: 'textfield',
                    name: 'eventName',
                    fieldLabel: getCommonTranslation('EVENT_NAME'), //Event Name
                    //allowBlank: false,
                    maxLength: 255
                }, {
                    xtype: 'textfield',
                    name: 'conductedBy',
                    itemId: 'cmbconductedBy',
                    fieldLabel: getCommonTranslation('CONDUCTED_BY'), //Booked By
                    visible:false,
                    hidden:true,
                    //allowBlank: false
                }, {
                    xtype: 'datefield',
                    name: 'eventDate',
                    itemId: 'eventDate',
                    vtype: 'daterange',
                    endDateField: 'toDate',
                    fieldLabel: getCommonTranslation('EVENT_DATE'), //Event Date
                    editable: false,
                    //minValue: new Date(),
                    //value:new Date(),
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	render: function(obj) {
    						obj = dateFormatRender(obj);						
    						obj.setValue(new Date());
    					}
                    },
                    //allowBlank: false
                }, {
                    xtype: 'numberfield',
                    name: 'noOfParticipants',
                    itemId:'numOfParticipants',
                    fieldLabel: getCommonTranslation('PARTICIPANTS'), //NO. Of Participants
                    maxLength: 5,
                    minValue:0,
                    value:0,
                    ////allowBlank: false,
                    validator: function(value){
                    	var validText = getCommonTranslation('ENTER_ONLY_INTEGER_NUMBER');
                    	var patt = new RegExp('^[0-9]+$');
                    	var res = patt.test(value);
                        if(res) {
                            return true;
                        } else {
                            return validText;
                        }
                    }
                }]
            }, {
                flex: .2,
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    //xtype: 'customcombobox',
                	xtype: 'textfield',
                    name: 'bookingPurpose',
                    itemId: 'cmbBookingPurpose',
                    fieldLabel: getCommonTranslation('EVENT_PURPOSE'), //Event Purpose
                    //store: 'facilitiesresources.resourcebooking.ResourceBookingPurposeStore',
                    valueField: 'id',
                    displayField: 'value',
                    editable: false,
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    //allowBlank: false
                }, 
                {
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('COMPLETE_DAY'), //Complete Day
                    name: 'isCompleteDay',
                    checked: true,
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'chkCompleteDay',
                    style:{
                    	marginTop:'32px'
                    }
                }, {
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('RECURRING'), //Recurring
                    name: 'isRecurring',
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'chkRecurring',
                    style:{
                    	marginTop:'32px'
                    }
                }]
                }/*, {
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('COMPLETE_DAY'), //Complete Day
                    name: 'isCompleteDay',
                    checked: true,
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'chkCompleteDay',
                    style:{
                    	marginTop:'32px'
                    }
                }*/, {
                    xtype: 'datefield',
                    name: 'toDate',
                    itemId: 'toDate',
                    vtype: 'daterange',
                    //minValue: new Date(),
                    startDateField: 'eventDate',
                    fieldLabel: getCommonTranslation('TO_DATE'), //To Date
                    editable: false,
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    }
                    //allowBlank: false
                }, {
                    xtype: 'textfield',
                    name: 'venue',
                    fieldLabel: getServiceRequestTranslation('VENUE'),
                    //maxLength: 250,
                    //allowBlank: true,
                    maxLength: 45
                }
			]
            }, {
                flex: .2,
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
        			xtype: 'customcombobox',
        			name: 'committee',
        			itemId:'committeeItemId',
        			//store:'committee.committee.CommitteeStore',
        			displayField:'valueCode',
        			valueField:'id',
        			queryParam:'name',
        			hidden:true,
        			//allowBlank:false,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			minChars:3,
        			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			triggerAction: '',
        			forceSelection:true,
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				//emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			},
        			fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME")
        		},{
                    xtype: 'textfield',
                    name: 'committee',
        			itemId:'committeeItemId',
                    //fieldLabel: getCommonTranslation('COMMITTEE_NAME'), //Booked By
                    fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME"),
                    valueField: 'id',
                    displayField: 'valueCode',
    	            maxLength: 100
        		},{
                    //xtype: 'customcombobox',
                    xtype: 'textfield',
                    name: 'bookedBy',
                    itemId: 'cmbBookedBy',
                    fieldLabel: getCommonTranslation('BOOKED_BY'), //Booked By
                    //store: 'common.ActiveUserStore',
                    valueField: 'id',
                    displayField: 'valueCode',
                    //allowBlank: false,
                    queryParam:'name',
    				minChars:3,
    				typeAhead:false,
    				forceSelection:true,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				//triggerAction: '',
    				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	            maxLength: 100,
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					//emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
        	        
                }/*{
                    xtype: 'textfield',
                    name: 'eventName',
                    fieldLabel: getCommonTranslation('EVENT_NAME'), //Event Name
                    //allowBlank: false
                }*//*, {
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('RECURRING'), //Recurring
                    name: 'isRecurring',
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'chkRecurring',
                    style:{
                    	marginTop:'32px'
                    }
                }*/,{
                    xtype: 'multiselectcombofield',
                    name: 'repeatOn',
                    itemId: 'repeatOnItemId',
                    fieldLabel: getServiceRequestTranslation('EVENT_REPEAT_ON'),
                    //autoloadStore: false,
                    store: 'transport.serviceRoute.WeekDays',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: true,
                    hidden:true,
                    minChars: 3,
                    typeAhead: true,
                    triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                    enableKeyEvents: 'true',
                    hideTrigger: false,
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                },{
					xtype : 'fieldcontainer',
//					width: 'auto',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
                    xtype: 'timefield',
                    name: 'timeFrom',
                    itemId: 'timeFrom',
                    fieldLabel: getCommonTranslation('TIME_FROM'), //Time From
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    endTimeField: 'timeTo',
                    //allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}
                }, {
                    xtype: 'timefield',
                    name: 'timeTo',
                    itemId: 'timeTo',
                    fieldLabel: getCommonTranslation('TIME_TO'), //Time To
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT, //Select to time
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    startTimeField: 'timeFrom',
                    //allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}		
                }]
				},{
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('MANDATORY_EVENT'), //This event is mandatory
                    name: 'isMendatory',
                    inputValue: 'true',
                    hidden:true,
                    uncheckedValue: 'false',
                    itemId: 'isMandatoryEvent',
                    style:{
                    	marginTop:'32px'
                    }
                }]
            }]
        },{
        	xtype: 'fieldcontainer',
        	layout : 'hbox',
        	style:{
        		marginTop: '-70px',
        		marginLeft: '20px'
        	},
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items: [{
        		xtype: 'textareafield',
        		name: 'eventDesc',
        		fieldLabel: getCommonTranslation('EVENT_DESC'), //Event Description
        		maxLength: 255
        	},{ 
        		xtype: 'tbspacer', 
        		width: 50 
        	},{
        		xtype: 'textareafield',
        		name: 'purposeDesc',
        		fieldLabel: getCommonTranslation('PURPOSE_DETAIL'), //Purpose Detail
        		maxLength: 255
        	}]
        },{
        	xtype: 'fieldcontainer',
        	style:{
        		marginLeft: '20px'
        	},
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items: [{
        		xtype:'meetingdocumentgrid',
        		itemId:'documentsGridEmployeeResourceBooking',
        		//hidden:true,
        		style:{
        			marginLeft:'0px !important'
        		}
        	}]
        }, {
            xtype: 'fieldcontainer',
            style:{
            	marginTop: '0px',
            	marginLeft: '20px'
            },
            defaults: {
                width: 536,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'label',
                width: 150,
                html: "<span style='font-weight: bold;'>" + getServiceRequestTranslation('EVENT_BANNER') + ":</span>",
                style: {
                	marginBottom: '10px',
                	display:'inline-block'
                }
            },{
            	html: '<i>'+getCommonTranslation('PLEASE_PREFER_IMAGE_SIZE')+'</i>',
            	margin: 0,
            },{
            	xtype: 'photouploadform',
            	itemId: 'eventBannerItemId'
            }, {
            	xtype:'image',
                itemId: 'eventBannerBgImage',
                border: 1,
                style: {
                    borderColor: 'black',
                    borderStyle: 'solid'
                },
                width: 222,
                height: 150,
                src:'resources/images/Event_Banner.png'
            },{
            	xtype:'hidden',
            	itemId: 'eventBannerURLItemId',
            	name: 'eventBannerURL'
            }]
        }, {
        	xtype:'panel',
        	hidden:true,
        	frame:true,
        	header :false,            	
        	layout:{
        		type:'hbox'
        	},
        	items : [{
				xtype : 'checkboxfield',
				boxLabel : 'BOOKED',
				disabled:true
			},{
				xtype : 'checkboxfield',
				boxLabel : 'AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			},{
				xtype : 'checkboxfield',
				boxLabel : 'PARTLY AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			}]
        }]
});
