Ext.define('Academia.view.facilitiesresources.resourcemaster.FacilityTree', {
	 extend: 'Ext.tree.Panel',
	 alias:'widget.facilitytree',
	 itemId:'facilitytree',
	 border: true,
	 autoScroll:false,
	 //autoHeight: false,
	 height: 600,
	 title:getCommonTranslation('INTERNAL_FACILITIES_ATTACHED_EQUIPMENTS'), //Internal Facilities and Attached Equipments
	 store:'facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesTreeStore',	 	 	 
	 /*
	  * UI Class for the tree without the icons
	  */
	 cls: 'no-tree-icon full-page-tree',
	 rootVisible: true,
	 multiSelect: false,
	 singleExpand: false,
	 preserveScrollOnRefresh : true,
	 animate: false,
	 style:{
			marginTop:'16px !important',
			marginLeft:'19px !important',
			marginRight:'14px !important',
			width: '100%'
	    },
	 tbar:[{
	        xtype: 'splitbutton',
	        itemId: 'spBtnFacilityTabAddActions',
	        text: getCommonTranslation('MOREACTIONS'), //More Actions
	        tooltip: getCommonTranslation('MOREACTIONS'), //Click on this you can perform add equipment/facility operations
	        menu: [{	        	
	        	tooltip: getCommonTranslation('ADD_FACILITY'), //Add Facility  
	    	    itemId: 'btnAddFacility',
	    	    text:getCommonTranslation('ADD_FACILITY') //Add Facility
	        },{
	        	tooltip: getCommonTranslation('ADD_EQUIPMENT'),  //Add Equipment
	     	    itemId: 'btnAddEquipment',
	     	    text:getCommonTranslation('ADD_EQUIPMENT') //Add Equipment
	        }/*,{
	        	tooltip: getCommonTranslation('ADD_HOSTEL'),  //Add Hostel
	     	    itemId: 'btnAddHostel',
	     	    text:getCommonTranslation('ADD_HOSTEL') //Add Hostel
	        }*/
	        ],listeners: { click: function() { this.showMenu(); } }
	    },{
    	    xtype: 'button',
    	    tooltip: getCommonTranslation('EDIT'),  //Edit
    	    itemId: 'btnEdit',
    	    iconCls:'icon-editbutton',
			cls:'editbutton'
    	    //text:getCommonTranslation('EDIT') //Edit
    	},{
			xtype : 'button',				
			itemId : 'btnView',
			tooltip : getCommonTranslation('VIEW'),//View
			iconCls: 'icon-View',
			cls:'iconView'	
			//text : getCommonTranslation('VIEW')  //View
		},{
			xtype : 'button',				
			itemId : 'btnDelete',
			tooltip :getCommonTranslation('DELETE'), //Delete
			iconCls: 'icon-Delete',
			cls:'iconDelete'
//			text : getCommonTranslation('DELETE') //Delete
		},{
			xtype:'customcombobox',
			itemId:'cmbLocation', 
			fieldLabel:getCommonTranslation('RESOURCE_LOCATION'),
			store:'facilitiesresources.resourcemaster.LocationListStore',
			valueField : 'id',
			displayField : 'value',
			labelWidth: 58,
			width:'20%',
			editable:false,
//			emptyText:getCommonTranslation('SELECT_LOCATION'), //Select Location
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceGroup',
			fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
			store:'facilitiesresources.resourcebooking.ResourceGroupStore',
			valueField : 'name',
			displayField : 'value',			
			editable:false,
			width:'15%',
			labelWidth: 58,
			value:'',
//			emptyText:getCommonTranslation('SELECT_RESOURCE_GROUP'), //Select Resource Group
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceType',
			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
			store:'facilitiesresources.resourcebooking.ResourceTypeStore',
			valueField : 'id',
			displayField : 'value',
			width:'15%',
			labelWidth: 58,
			value:'',
			editable:false,
//			emptyText:getCommonTranslation('SELECT_RESOURCE_TYPE'), //Select Resource Type
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype:'customcombobox',
			itemId:'cmbResourceStatus', 
			fieldLabel:getCommonTranslation('RESOURCE_STATUS'),
			store:'facilitiesresources.resourcemaster.ResourceStatusStore',
			valueField : 'value',
			labelWidth: 58,
			displayField : 'name',			
			editable:false,
			width:'15%',
			value:'', 
//			emptyText:getCommonTranslation('SELECT_RESOURCE_STATUS'), //Select Resource Status
			queryMode: 'local',
			triggerAcation:'all',
			fourceSelection:true		
		},{
			xtype : 'button',				
			itemId : 'exportReportsId',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS')		
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonItemId',
			buttonAlign : 'left',
//			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]    
});