Ext.define('Academia.view.facilitiesresources.resourcemaster.PrimaryAcademyLocationForm',{
	extend:'Ext.form.Panel',
	alias:'widget.primaryacademyloc',
	 plugins : "formlabelrequired",
	frame:true,
	titleCollapse: true,
	resourceAcademyLocationPrograms: null,
	courses: null,
	cls:'x-form-fixed-footer-parent',
	items:[{
		xtype:'hidden',
		name:'version',
		itemId:'version'	
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults : {
			labelAlign:'top',
			width: 256
		},	
		items:[{  xtype: 'customcombobox',
        		name: 'academyLocation',
        		fieldLabel:getCommonTranslation('PRIMARY_ACADEMY_LOCATION'),
        		store:'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
        		itemId: 'academyLocation',
                width: 256,
        		valueField: 'id',
        		displayField: 'value',
        		queryParam:'nameOrCode',
        		minChars:3,
        		typeAhead:false,
        		forceSelection:true,
        	    allowBlank: false,
        	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	    enableKeyEvents  : 'true',
        	    hideTrigger:false,
        	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	    triggerAction: '',
        	    listConfig: {
        	    	listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        	        loadingText: getCommonTranslation('SEARCHING'),
        	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	        getInnerTpl: function() {
        	            return '<div class="search-item">' +
        	                '{value}' +
        	            '</div>';
        	        }
        	    }
            },{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('ASSIGN_CALENDER'),
			//store:'facilitiesresources.resourcemaster.CalenderStore',
			valueField:'id',
			displayField:'value',
			itemId:'comboAssignCalender',
			name:'calendar',	
			forceSelection:true,
			allowBlank:false,
			editable:true,
	        listeners: {
	            beforerender: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcemaster.MappedCalenderStore');
	                combo.bindStore(store);
	            }
	        }
		}]
		
	},{
		xtype:'fieldcontainer',
		itemId:'programsViewChange',
		layout:'hbox',
		items:[{
			xtype:'displayfield',
			labelWidth: 90,
			width: 250,
			style:{wordBreak: 'break-all'},
			fieldLabel:getCommonTranslation('PROGRAMS'),
			value:getCommonTranslation('ALL_PROGRAMS')
		},{
			xtype:'button',
			text:getCommonTranslation('VIEW'),
			ui:'CustomBtnSubmit',
			cls:'CustomBtnSubmitToolbaar',
			itemId:'btnViewAvailableProgram'
		},{
			xtype:'button',
			text:getCommonTranslation('CHANGE'),
			ui: 'CustomBtnSubmit',
			cls:'CustomBtnSubmitToolbaar',
			itemId:'btnAvailableProgram',
			style:{
				marginLeft:'6px !important'
			}
		}]
	},{
		xtype:'fieldcontainer',
		itemId:'coursesViewChange',
		layout:'hbox',
		cls:'form-fixed-footer',
		items:[{
			xtype:'displayfield',
			labelWidth: 90,
			width: 250,
			fieldLabel:getCommonTranslation('COURSES'),
			style:{wordBreak: 'break-all'},
			value:getCommonTranslation('ALL_COURSES')
		},{
			xtype:'button',
			text:getCommonTranslation('VIEW'),
			ui:'CustomBtnSubmit',
			itemId:'btnViewAvailableCourses'
		},{
			xtype:'button',
			text:getCommonTranslation('CHANGE'),
			ui: 'CustomBtnThird',
			itemId:'btnAvailableCourses'
		}]
	}]	
});