/**
 * @author Soham.Gurjar
 */
Ext.define('Academia.view.facultyCourseInterest.DeclineWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.declinewindow',
	modal: true,
	autoScroll:true,
	title:getCommonTranslation('DECLINE_COMMENT'),
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		defaults:{
			labelAlign:'top',
			autoScroll:false
		},
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items:[{
					xtype: 'customcombobox',
					name: 'actionReason',
					itemId:'actionReasonId',
					fieldLabel: getCommonTranslation('ACTION_REASON'),
					store: 'lecturercostingdefinition.ActionReasonStore',
					valueField: 'id',
					displayField: 'code',
					typeAhead:true,
					forceSelection:true,
					allowBlank: false,
					width: 536
				}]
		},{
			xtype: 'fieldcontainer',
			 layout: 'fit',
			 defaults: {
				 labelAlign: 'top'
			 },
			 height: 'auto',
			items:[{
				 xtype: 'textarea',
				 name: 'comments',
				 itemId:'comments',
				 fieldLabel: getCommonTranslation('COMMENTS'),
				 width: 536,
				 maxLength:512,
				resizable: false,
				allowBlank: false,	
				 listeners:{
					 resize: function( ta, width, height, oldWidth, oldHeight, eOpts ){
						 try{
							 if(ta.getHeight() > 20){
								 var resizeHandlerDiv = Ext.query("#"+ta.id+"-rzwrap-rzproxy")[0];
								 ta.setHeight(resizeHandlerDiv.offsetHeight - 20);
							 }
						 }
						 catch(e){
							 //--
						 }
					 }
				 }
			 }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				formBind: true,
				text: getCommonTranslation('DECLINE'),
				itemId: 'declineSubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'declineCancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]

});
