Ext.define('Academia.view.facultyCourseInterest.HighestQualificationInnerGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.highestqualificationinnergrid',
	border:true,
	autoScroll:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {    	     
    	var grid=this;
    	var store=Ext.create('Academia.store.lecturercostingdefinition.HighestQualificationGridStore');
    	Ext.apply(this, {
    		store: store        
    	});
    	this.callParent(arguments);
    	var custompagingtoolbar=grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		custompagingtoolbar.bindStore(store);        	
    	}
    },
    tbar: [],
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	            displayInfo: true
	        }]
	    }],
	columns : [{
        header: getCommonTranslation('QUALIFICATION_TYPE'), 
        dataIndex: 'qualificationType',      
        flex: .5
    }, {
        header: getCommonTranslation('QUALIFICATION_CATEGORY'), 
        dataIndex: 'qualificationCategory',
        flex: .5
    }, {
        header: getCommonTranslation('EMP_QUALIFICATION_NAME'),
        dataIndex: 'qualificationName',	
        flex: .3
    }, {
        header: getCommonTranslation('MAJOR_1'),
        dataIndex: 'qualificationMajor1',
        flex: .3
    },{
        header: getCommonTranslation('MAJOR_2'),
        dataIndex: 'qualificationMajor2',
        flex: .3
    },{
        header: getCommonTranslation('MAJOR_3'),
        dataIndex: 'qualificationMajor3',
        flex: .3
    },{
        header: getCommonTranslation('HEQF_LEVEL'),
        dataIndex: 'qualificationHEQFLevel',
        flex: .3
    },{
        header: getCommonTranslation('INSTITUTION'),
        dataIndex: 'qualificationInstitution',
        flex: .5
    },{
        header: getCommonTranslation('QUALIFICATION_START_DATE'),
        dataIndex: 'qualificationStartDate',
        flex: .5,
        renderer : function(date) {
			return dateRender(date);
		}
    },{
        header: getCommonTranslation('QUALIFICATION_END_DATE'),
        dataIndex: 'qualificationEndDate',
        flex: .5,
        renderer : function(date) {
			return dateRender(date);
		}
    },{
        header: getCommonTranslation('QUALIFICATION_APPROVAL_LEVEL'),
        dataIndex: 'qualificationApprovalLevel',  
        flex: .5
    },{
        header: getCommonTranslation('QUALIFICATION_USED_IN_APPROVAL'),
        dataIndex: 'qualificationUsedInApproval',  
        flex: .5
    },{
        header: getCommonTranslation('STATUS'),
        dataIndex: 'isCompleted',  
        flex: .3,
        renderer: function(value, metadata, record) {
			var val;
			if(value==true){
				return 'Completed';
			}else if(value==false){
				return 'Incomplete';
			}
		}
    }]
	
});
