/**
 * Ravindra Merawat
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.CourseLevelStudentAttendanceSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.courselevelstudentattendancesearch',  
	plugins : "formlabelrequired",
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'courseLevelAcademicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			editable:false,
			typeAhead:false,
			allowBlank:false

		},{
			xtype: 'customcombobox',
			name:'studentName',
			itemId:'courseLevelStudentId',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore',
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
	       	 xtype: 'customcombobox',
	         name: 'courseLevelStudentStatus',
	         itemId: 'courseLevelStudentStatusId',
	         fieldLabel: getPersonModuleTranslation('STATUS'),
	         value:true,
	         store: Ext.create('Academia.store.common.StatusComboStore'),
	         valueField: 'value',
	         displayField: 'name',
	         editable:false,
	    }]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseLevelCourseVariantId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField: 'courseVariantCode',
			valueField: 'id',
			triggerAction: 'all',
			queryParam:'name',
			minChars:3,
			width: 536,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			typeAhead:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}


		}]
	},
	{ 
		xtype : 'fieldcontainer',
		layout:'hbox',
		itemId:'timeContainer',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'timefield',
			name : 'fromTime',		
			itemId : 'courseLevelFromTime',			
			fieldLabel:getProgramandcourseTranslation('START_TIME'),
			format:'g:i A',
			increment: 1,
			width:107,
			listeners:{
				change:function(obj,val){
					if (!isNullOrEmpty(val)) {
						var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
						obj.nextSibling().setMinValue(sDate);	
					}
				}
			},

		},{
			xtype : 'timefield',
			name : 'toTime',		
			itemId : 'courseLevelToTime',			
			fieldLabel:getProgramandcourseTranslation('END_TIME'),
			format:'g:i A',
			increment: 1,
			width:107,
			listeners:{
				change:function(obj,val){
					if (!isNullOrEmpty(val)) {
						var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
						obj.previousSibling().setMaxValue(eDate);
					}
				}
			}
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		width: 500,
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '11px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'startDate',
				itemId:'startDate',
				endDateField : 'endDate',
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},
			{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'endDate',
				itemId : 'endDate',
				startDateField : 'startDate',
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel:getProgramandcourseTranslation('ATTENDANCE_STATUS'),
				itemId:'courseLevelAttendanceStatus',
				name:'attendanceStatus',
				store:'attendance.StudentAttendanceStatusStore',
				valueField : 'id',
				displayField : 'value'
			},{
				xtype: 'numberfield',
				itemId: 'courseLevelAbsentForLast',
				name: 'absentForLast',
				fieldLabel:getProgramandcourseTranslation('ABSENT_FOR_CONSECUTIVE_DAYS'),
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				allowDecimals:false,
				enforceMaxLength : true
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'courseLevelSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'courseLevelResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});