/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.FDMOutwardItemUpdateStatusWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.fdmoutwarditemupdatestatuswin',
	title:getServiceRequestTranslation('FD_UPDATE_STATUS'),
	frame: true,
	modal:true,
	id:'countWinItemId',
	method: 'POST',
	resizable:true,
	autoScroll: true,
	height: '60%',
    width: '55%',
	items: [{
		xtype:'form',
		itemId:'fdmOutwardItemUpdateStatusFormItemId',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'idItemId',
				name: 'id'
			},{
				xtype:'displayfield',
				name:'itemCategoryCode',
				itemId:'itemCategoryItemId',
				fieldLabel: getServiceRequestTranslation('FD_ITEM_CATEGORY')
			},{
				xtype:'displayfield',
				name:'outwardNo',
				itemId:'outwardNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_OUTWARD_NO')
			},{
				xtype:'displayfield',
				name:'outwardSenderId',
				itemId:'outwardSenderIdItemId',
                fieldLabel: getServiceRequestTranslation('FD_SENDER_NAME')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'displayfield',
				name:'sentDate',
				itemId:'sentDateItemId',
				fieldLabel: getServiceRequestTranslation('FD_SENT_DATE')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name:'outwordItemStatus',
				itemId:'outwordItemStatusItemId',
				store:'fdmanagement.FDOutwardItemStatusStore',
				fieldLabel: getServiceRequestTranslation('FD_ITEM_STATUS'),
				valueField: 'value',
				displayField: 'name',
				typeAhead:false,
				value: 'Delivered',
				allowBlank:false,
                forceSelection: true,
                editable: false,
                maxLength: 11,
			},{
				xtype: 'datefield',
				name: 'outwardDeliveryDate',
				itemId: 'outwardDeliveryDateItemId',
				vtype: 'daterange',
//				value: new Date(),
                maxValue: new Date(),
				fieldLabel: getServiceRequestTranslation('FD_DELIVERY_DATE'),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'datefield',
				name: 'outwardeReturnDate',
				itemId: 'outwardeReturnDateItemId',
				vtype: 'daterange',
//				value: new Date(),
                maxValue: new Date(),
				fieldLabel: getServiceRequestTranslation('FD_RETURN_DATE'),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				},
				hidden:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				name:'outwardReceivedBy',
				itemId:'outwardReceivedByItemId',
                maxLength: 50,
                //vtype:'NoSpaceAndSpecialCharactersAsInput',
				fieldLabel: getServiceRequestTranslation('FD_RECEIVED_BY')
			},{
				xtype: 'textfield',
				name:'outwardPODNo',
				itemId:'outwardPODNoItemId',
                vtype: 'NoSpaceAndSpecialCharactersWithNumberAsInput',
                maxLength: 30,
				fieldLabel: getServiceRequestTranslation('FD_POD_NO')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textarea',
				name: 'outwardReturnReason',
				itemId: 'outwardReturnReasonItemId',
				fieldLabel: getServiceRequestTranslation('FD_REASON_FOR_RETURNING'),
				width: 536,
				enforceMaxLength : true,
				maxLength:250,
				hidden:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype:'fdoutwarditemupdatestatusdocumentgrid',
				itemId : 'fdoutwarditemupdatestatusdocumentgridItemId',
				style:{
					marginLeft:'0px'
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'saveFdmoutwarditemupdatestatuswinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
                formBind: true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'fdmoutwarditemupdatestatuswinUploadId',
				ui: 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});