/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.facultyPortal.FDMEUpdateStatusWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.fdmeupdatestatuswin',
	title:getServiceRequestTranslation('FD_UPDATE_ACKNOWLEDGEMENT_STATUS'),
	frame: true,
	modal:true,
	id:'countWinItemId',
	method: 'POST',
	resizable:true,
	autoScroll: true,
    height: '55%',
    width: '52%',
	items: [{
		xtype:'form',
		itemId:'fdmeUpdateStatusFormItemId',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'idItemId',
				name: 'id'
			},{
				xtype:'displayfield',
				name:'inwardNo',
				itemId:'inwardNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_INWARD_NO')
			},{
				xtype:'displayfield',
				name:'nameOfSenderId',
				itemId:'nameOfSenderItemId',
                fieldLabel: getServiceRequestTranslation('FD_SENDER_NAME')
			},{
				xtype:'displayfield',
				name:'noOfPieces',
				itemId:'noOfPiecesItemId',
				fieldLabel: getServiceRequestTranslation('FD_NO_OF_PIECES')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name:'acknowledgeStatus',
				itemId:'acknowledgeStatusItemId',
				store:'fdmanagement.AcknowledgeStatusStore',
                fieldLabel: getServiceRequestTranslation('FD_STATUS'),
				valueField: 'value',
				displayField: 'name',
				typeAhead:false,
				value: 'Received',
				allowBlank:false,
                forceSelection: true,
                editable: false,
                maxLength: 40
			},{
				xtype: 'datefield',
				name: 'acknowledgmentDate',
				itemId: 'acknowledgmentDateItemId',
				vtype: 'daterange',
				//value: new Date(),
                maxValue: new Date(),
                fieldLabel: getServiceRequestTranslation('FD_DATE'),
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textarea',
				name: 'receiverRemarks',
				itemId: 'receiverRemarksItemId',
				fieldLabel: getServiceRequestTranslation('FD_REMARKS'),
				width: 536,
				enforceMaxLength : true,
				maxLength:250
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'saveFdmeupdatestatuswinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
                formBind: true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'cancelFdmeupdatestatuswinItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]	
});