/**
 *  @author Rohit Thadani
 */
var statementOfAccountStore = 'feeandpayment.ActualAccountStatementGridStore';
Ext.define('Academia.view.feeandpayment.ActualAccountStatementGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.actualaccountstatementgrid',
	store : statementOfAccountStore,
	title: getCommonTranslation('LIST_OF_STUDENT'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},  
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCourseTxCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'exportReportItemId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : statementOfAccountStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getCommonTranslation('ADMISSION_DATE'),
		dataIndex : 'admissiondate',
		hidden: true,
		flex:1,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'studentStatus',
		hidden: true,
		flex:1,
		renderer: function(value, metadata, record) {
			var val;
			if(value==true){
				val =getCommonTranslation("ACTIVE");
			}else if(value==false){
				val =getCommonTranslation("INACTIVE");
			}
			return val;
		}

	},{
		header : getCommonTranslation('OPENING_BALANCE_DR'),
		dataIndex : 'openingBalanceDR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('OPENING_BALANCE_CR'),
		dataIndex : 'openingBalanceCR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BASE_DEBIT'),
		dataIndex : 'baseCurrencyDebitAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BASE_CREDIT'),
		dataIndex : 'baseCurrencyCreditAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BALANCE_DR'),
		dataIndex : 'balanceAmountDR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value) && value>0){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BALANCE_CR'),
		dataIndex : 'balanceAmountCR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value) && value>0){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		flex:1
	},{
		header : getCommonTranslation('TOTAL'),
		dataIndex : 'baseCurrencyBalanceAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(!isNullOrEmpty(record.data.debitCreditCode)){
					return currencyRenderer(value,record.get("baseCurrencyId"))+" "+record.data.debitCreditCode;
				} else {
					return currencyRenderer(value);
				}
			} else {
				return "";
			}
		},
		flex:1
	}]
});
