/**
 *  @author Rohit Thadani
 */
var applicantStatementOfAccountStore = 'feeandpayment.ActualAccountStatementGridStore';
Ext.define('Academia.view.feeandpayment.ActualApplicantAccountStatementGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.actualapplicantaccountstatementgrid',
	store : applicantStatementOfAccountStore,
	title: getCommonTranslation('LIST_OF_APPLICANTS'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},  
	tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCourseTxCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.ActualAccountStatementGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
	 },
	columns: [{
		header : getCommonTranslation('APPLICANT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'printName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		hidden: true,
		flex:1
	},{
		header : getCommonTranslation('OPENING_BALANCE_DR'),
		dataIndex : 'openingBalanceDR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('OPENING_BALANCE_CR'),
		dataIndex : 'openingBalanceCR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('DEBIT'),
		dataIndex : 'baseCurrencyDebitAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'baseCurrencyCreditAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			} else {
				return "";
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BALANCE_DR'),
		dataIndex : 'balanceAmountDR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value) && value>0){
				return currencyRenderer(value,record.get("currencyId"))+" "+record.data.debitCreditCode;
			} else {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		flex:1
	},{
		header : getCommonTranslation('BALANCE_CR'),
		dataIndex : 'balanceAmountCR',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value) && value>0){
				return currencyRenderer(value,record.get("currencyId"))+" "+record.data.debitCreditCode;
			} else {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		flex:1
	},{
		header : getCommonTranslation('TOTAL'),
		dataIndex : 'baseCurrencyBalanceAmount',
		hidden: true,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(!isNullOrEmpty(record.data.debitCreditCode)){
						return currencyRenderer(value,record.get("baseCurrencyId"))+" "+record.data.debitCreditCode;
				} else {
					return currencyRenderer(value);
				}
			} else {
				return "";
			}
		},
		flex:1
	}]
});
