/**
 * @author Deepak.nigam
 */
Ext.define('Academia.view.feeandpayment.AdvanceFeeReportForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.advancefeereportform',
	//autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls: 'customSearchInnerPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'billType',
				itemId:'billType',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_TYPE'),
				store:Ext.create('Academia.store.feeandpayment.managebill.BillTypeSearch'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{  
				xtype: 'customcombobox',
				name: 'recieptView',
				itemId:'recieptView',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECIEPT_VIEW'),
				store: 'feeandpayment.dashboardAndReports.FeeFindAllBillTypedUser',
				//store: 'feeandpayment.dashboardAndReports.FeePlanTypeProgramAndService',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
				},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				//width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.dashboardAndReports.FeeStudentDetailsByStudentCodeStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				//allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			},{
	        	 xtype: 'statusCombo',
	             name: 'STATUS',
	             itemId: 'statusComboItemId'
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				width: 536,
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
				store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sponsors',
				itemId:'sponsors',
				width: 536,
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
				store: 'feeandpayment.managebill.Sponsors',
				valueField: 'id',
				displayField: 'sponsorName',
				queryParam:'sponsorNameOrCode',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode}/{sponsorName}' +
						'</div>';
					}
				}
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{  
				xtype: 'customcombobox',
				name: 'programName',
				itemId:'programName',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store: 'feeandpayment.dashboardAndReports.FeeProgramCodeStore',
				valueField: 'id',
				displayField: 'valueCode',
				typeAhead: true,
				forceSelection: true,
				triggerAction: 'all',
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
				
			},{
				xtype: 'customcombobox',
				name: 'batchName',
				itemId:'batchName',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				store: 'feeandpayment.dashboardAndReports.FeeBatchNameByProgramStore',
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype: 'fieldcontainer',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout: 'hbox',
			style:{
    			'margin-left':'-32px !important'
    		},
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	  },
	  ]
	});