/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.AssociateStudentProgramListForStudent', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.associatestudentprogramlistforstudent',
	store : 'feeandpayment.ApplicantForStudentFeePlan',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_STUDENT'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.ApplicantForStudentFeePlan',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	columns: [{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STAGE'),
		dataIndex : 'stageName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_SEQUENCE'),
		dataIndex : 'feeRuleDesc',
		flex:1
	}]
});