/**
 * @author manisha wagh
 */
Ext.define('Academia.view.feeandpayment.CourseFeePlanMappingResultGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.coursefeeplanmappingresultgrid',
	//store: 'feeandpayment.stoPaymentPlanMappingGridStore',
	store: 'feeandpayment.stoCourseFeePlanMappingGridStore',
	title: getFeeAndPaymentCommonTranslation('COURSE_PROGRAM_MAPPING_RESULTS'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.stoCourseFeePlanMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMY'),
		dataIndex: 'academy',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('LOCATION'),
		dataIndex: 'location',
		flex:1,
		sortable:true
		
	},{
		header:  getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex: 'courseName',
		flex:1,
		sortable:true
		
	},{
		header : getCommonTranslation('PROGRAM_CODE'),
		dataIndex : 'programCode',
		flex : 1 
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex:1,
		sortable:true
	}]
});
