/**
 * @author Makrand Kulkarni 
 */
Ext.define('Academia.view.feeandpayment.FeeConfigHeadWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.feeconfigheadwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	cls:'enqgridsummarycls horizontalScrollingFixed',
	refreshStoreData:true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('FEES_HEADS_COVERED'),
	 defaults:{
	        layout:'vbox',
	        width:'100%'
	    },
	items : [{
			xtype: 'grid',
			store : 'feeandpayment.FeeConfigHeadStore',
			autoScroll: false,
			itemId : 'billHeaderGrid',
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			/*features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],*/
			/*dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'feeandpayment.FeeConfigHeadStore',
					emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],*/
			features: [{
				id: 'group',
				ftype: 'groupingsummary',
				groupHeaderTpl: '{name}',
				hideGroupedHeader: false,
				enableGroupingMenu: false,
				showSummaryRow : false
			}],
			columns: [{
				header : getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'),
				dataIndex : 'fee_HEAD_NAME',
				flex : 1
			}
			,{
				header : getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
				dataIndex : 'fee_AMOUNT',
				flex : 1,
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return currencyRenderer(value,record.get("currencyId"));
					}                    
				} 
			}
			, {
				text: getFeeAndPaymentCommonTranslation('PAYMENT_PERIOD'),
				dataIndex: 'payment_PERIOD',
				sortable: true,
				flex: 1,
				renderer:function(value){
					if(value == 'SESSIONS'){
						return getCommonTranslation('SESSIONS');
					}
					else if(value == 'PARTICIPANT'){
						return getCommonTranslation('PARTICIPANT');
					}
					else if(value == 'ADHOC_PERIODS'){
						return getCommonTranslation('ADHOC_PERIODS');
					}
					else if(value == 'FIXED_TIME_PERIODS'){
						return getCommonTranslation('FIXED_TIME_PERIODS');
					}
					else if(value == 'PROGRAM_PERIOD'){
						return getCommonTranslation('PROGRAM_PERIOD');
					}
					else if(value == 'ONE_TIME'){
						return getCommonTranslation('ONE_TIME');
					}else if(value == 'INSTALLMENTS'){
						return getCommonTranslation('INSTALLMENTS');
					}
				}
			},
			{
				text: getFeeAndPaymentCommonTranslation('NO_OF_FEE_PAYMENT'),
				dataIndex: 'no_OF_FEE_PAYMENT',
				sortable: true,
				flex: 1,
			
			},
		{
				text: getFeeAndPaymentCommonTranslation('PDC_ALLOWED'),
				dataIndex: 'whether_INSTALL_POST_DATED',
				sortable: true,
				flex: 1,
				hidden: true,
			//	disabled:true,
				renderer:function(value){
					if(value){
						return getFeeAndPaymentCommonTranslation('YES');
					}else{
						return getFeeAndPaymentCommonTranslation('NO');
					}
				}
			} ,
			{
				text: getFeeAndPaymentCommonTranslation('WHETHER_DISCOUNT_APPLICABLE'),
				dataIndex: 'discount_TYPE',
				sortable: true,
				flex: 1,
				renderer:function(value){
					if(value == getFeeAndPaymentCommonTranslation('PERCENTAGE')){
						return getCommonTranslation('PERCENTAGE');
					}
					else if(value == getFeeAndPaymentCommonTranslation('FIXED_AMOUNT')){
						return getCommonTranslation('FIXED_AMOUNT');
					}
					else if(value == getFeeAndPaymentCommonTranslation('ADHOC')){
						return getCommonTranslation('ADHOC');
					}
				}
			}] 	

		}]
});
