/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.FeePlanDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.feeplandetailwin',
	title:getFeeAndPaymentCommonTranslation('FEE_PLAN'),
	frame: true,
	autoScroll:true,
	modal:true,
	maxHeight:550,    
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'feePlanForm',
		itemId:'feeplandetailformwin',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'feePlanId',
				itemId:'feePlanId',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_ID'),
				/*emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				readOnly:true,		
				emptyText: getCommonTranslation('ID_AUTOGENERATE'),
				readOnly:true,		
				enforceMaxLength : true,
				maxLength:255,
				regex: /[a-zA-Z0-9]+/,*/
			},{
				xtype: 'textfield',
				name: 'feePlanName',
				itemId:'feePlanName',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
				regex: /[a-zA-Z0-9]+/
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'feePlanType',
				itemId:'feePlanType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
				store: 'feeandpayment.FeePlanTypeStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype : 'radiogroup',
				itemId:'inheriFromFeePlanId',
				labelAlign : 'top',
				allowBlank: false,
				fieldLabel:getFeeAndPaymentCommonTranslation('INHERIT_FROM_FEE_PLAN'),
				items : [{
					boxLabel : getFeeAndPaymentCommonTranslation('YES'),
					name:'inheriFromFeePlan',
					inputValue : true,
					//checked : false
				},{
					boxLabel : getFeeAndPaymentCommonTranslation('NO'),
					name:'inheriFromFeePlan',	
					inputValue : false,
					checked : true
				}]
			},/*{	
				xtype: 'customcombobox',
				name: 'serviceProvided',
				itemId:'serviceProvided',
				fieldLabel: getFeeAndPaymentCommonTranslation('SERVICE'),
				store: 'feeandpayment.FeeServiceStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				hidden:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId:'courseId',
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('Course'),
				store: 'coursetransaction.studymaterialdistribution.CoursesAllStore',
				valueField: 'id',
				displayField: 'value',
				hidden:true,
				typeAhead:true,
				forceSelection:true
		}*/]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{	
					xtype: 'customcombobox',
					name: 'serviceProvided',
					itemId:'serviceProvided',
					fieldLabel: getFeeAndPaymentCommonTranslation('SERVICE'),
					store: 'feeandpayment.FeeServiceStore',
					valueField: 'id',
					displayField: 'value',
					allowBlank:false,
					hidden:true,
					typeAhead:true,
					forceSelection:true
				},/*{
					xtype: 'customcombobox',
					name: 'courseId',
					itemId:'courseId',
					allowBlank:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('Course'),
					store: 'coursetransaction.studymaterialdistribution.CoursesAllStore',
					valueField: 'id',
					displayField: 'value',
					hidden:true,
					typeAhead:true,
					forceSelection:true
				},*/{
					xtype: 'customcombobox',
					name: 'copyfeePlan',
					itemId:'copyfeePlanId',
					allowBlank:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN'),
					store: 'feeandpayment.CopyFeePlanStore',
					valueField: 'id',
					displayField: 'value',
					hidden:true,
					typeAhead:true,
					forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'whetherServiceReceivableId',
			hidden:true,
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'serviceReceivableId',
					fieldLabel: getFeeAndPaymentCommonTranslation('WHETHER_SERVICE_RECEIVABLE'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherServiceReceivable', inputValue: true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherServiceReceivable', inputValue: false}
					]
				}]
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'applicableForId',
					fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getFeeAndPaymentCommonTranslation('OTHERS'), name: 'applicableFor', inputValue:'Faculty'},
					        { boxLabel: getFeeAndPaymentCommonTranslation('STUDENT'), name: 'applicableFor', inputValue: 'Student'}
					]
				}]
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'validFrom',
				itemId:'validFrom',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				
				vtype: 'daterange',
				minValue:new Date(),
				editable:false,
				hidden:true,
				allowBlank: true,
				fieldLabel: getCommonTranslation('VALID_FROM')
			},{
				xtype: 'datefield',
				name: 'validTill',
				itemId:'validTill',
				fieldLabel: getFeeAndPaymentCommonTranslation('VALID_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				minValue:new Date(),
				editable:false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'currency',
				itemId:'currency',
				fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
				store: 'feeandpayment.FeeCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype:'checkbox',
				name:'generateAllBillsForSchools',
				itemId:'generateAllBillsForSchools',
				inputValue: true, 
				boxLabel:getCommonTranslation('GENERATE_ALL_BILLS_FOR_SCHOOL'),
				style:{marginTop:'24px !important'}
			},{
				xtype: 'datefield',
				name: 'billGenerationDate',
				itemId:'billGenerationDate',
				hidden:true,
				fieldLabel: getCommonTranslation('BILL_GENERATION_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				editable:false,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				inputValue: true, 
			},
			items:[{
				xtype:'checkbox',
				name:'whetherProrataBillingForSchool',
				itemId:'whetherProrataBillingForSchool',
				boxLabel:getCommonTranslation('WHETHER_PRO_RATA_FOR_SCHOOL')
			},{
				xtype:'checkbox',
				name:'isBillCancelationOnDeletePersonCover',
				itemId:'isBillCancelationOnDeletePersonCover',
				width: 350,
				boxLabel:getCommonTranslation('BILL_CANCELLATION_AFTER_PERSON_COVERED_REMOVAL')
			}]
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});