/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.FeeProjectedDiscountReportForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeprojecteddiscountreportform',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",

		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'multiselectcombofield',
				name : 'academyLocation',
				itemId:'academyLocationId',
				width: 536,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'qry',
				//minChars:3,
				typeAhead:true,
				//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable:false,
				forceSelection:true,
				//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				cls:'commonAutoHeightMultiselectField',
				/*listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}*/
			},{
				xtype: 'customcombobox',
				name: 'programGroup',
				itemId:'programGroupItemId',
				fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
				store:'program.ProgramGroupStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.ProgramGroupStore');
						combo.bindStore(store);
					}
				}
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			itemId:'searchByFeePlanType',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			},{
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:'feeandpayment.reports.StudentFeeReportProgramStore',
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'programName',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listeners: {
	                    beforerender: function(combo) {
	                        var store = Ext.create('Academia.store.common.ProgramForBillStore');
	                        combo.bindStore(store);
	                    }
		    	   },
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
			   },{
					xtype: 'customcombobox',
					name: 'batchId',
					disabled:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
					itemId:'batchId',
					store: 'enquiry.AcademicBatchStore',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}]
		},{
			
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			}]	
		
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('FROM_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				allowBlank:true
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('TO_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			}]	
		},{
			xtype: 'panel',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		//}]
	  }/*,{
		  xtype : 'projecteddiscountreportgrid',  // by default no change
		  width:'100%',
		  itemId: 'projecteddiscountreportgrid' 
	  }*/]
	});