/* @author Manisha Wagh
 */
Ext.define('Academia.view.feeandpayment.PaymentPlanMappingGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.paymentplanmappinggridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_MAPPING'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.stoPaymentPlanMappingGridStore',
		autoScroll: true,
		itemId : 'billHeaderGrid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.stoPaymentPlanMappingGridStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('ACADEMY'),
			dataIndex : 'academy',
			flex : 1,
		},{
			header : getFeeAndPaymentCommonTranslation('LOCATION'),
			dataIndex : 'location',
			flex : 2,
		},{
			header : getFeeAndPaymentCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex : 2,
		},{
			header : getFeeAndPaymentCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex : 2,
		},
		{
			header : getFeeAndPaymentCommonTranslation('SEAT_NAME'),
			dataIndex : 'seatTypeName',
			flex : 2,
		},
		{
			header : getFeeAndPaymentCommonTranslation('APPROVAL_STATUS'),
			dataIndex : 'approvalStatus',
			flex : 2,
		},
		{
			header : getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
			dataIndex : 'mappingStatus',
			flex : 2,
		}] 	

	}]
});
