/**
 *  @author P Kumar
 */

Ext.define('Academia.view.feeandpayment.PaymentPlanProgramBatchSeatTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentplanprogrambatchseattypegrid',
	title : getCommonTranslation('SEAT_TYPE'),
	store: 'feeandpayment.PaymentPlanALProgramBatchSeatTypeList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	/*
	 * 
	 * V2D-373016
	 *  dockedItems: [{
	    xtype : 'toolbar',
        dock : 'bottom',
        items : [ {
            xtype : 'custompagingtoolbar',
            plugins:['pagesize'],
            store : 'feeandpayment.PaymentPlanALProgramBatchSeatTypeList',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo : true
        }]
    }],*/
	//autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitPaymentMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex : 1	 
	}]
});