/**
 * @author SudarshanReddy
 */

Ext.define('Academia.view.feeandpayment.PaymentScheduleSessionWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.paymentschedulesessionwin',
	title:getFeeAndPaymentCommonTranslation('PAYMENT_SCHEDULE_SESSION'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		id:'feeplandetailformId',
		itemId:'feeplandetailform',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'radiogroup',
			itemId:'billingType',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILLING_TYPE'),
			items:[
			       { boxLabel:getFeeAndPaymentCommonTranslation('ADVANCE'), name: 'billingType', inputValue: 'ADVANCE'},
			       { boxLabel:getFeeAndPaymentCommonTranslation('ARREAR'), name: 'billingType', inputValue: 'ARREAR',checked:true }
			       ]
		},{  
			xtype: 'radiogroup',
			itemId:'sessionBillFor',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILLED_FROM'),
			items:[
			       { boxLabel:getFeeAndPaymentCommonTranslation('EVERY_N_SESSIONS'), name: 'sessionBillFor', inputValue: 'EVERY_N_SESSIONS'},
			       { boxLabel:getFeeAndPaymentCommonTranslation('EVERY_PERIOD'), name: 'sessionBillFor', inputValue: 'EVERY_PERIOD',checked:true }
			       ]
	   },{
		   xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{ 
					xtype: 'numberfield',
					name: 'noOfSession',
					itemId:'noOfSession',
					minValue:1,
					hideTrigger:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_SESSION'),
					allowBlank:false
				},{
					xtype: 'customcombobox',
					name: 'periodType',
					itemId:'periodType',
					fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PERIOD_TYPE'),
					store: 'feeandpayment.PeriodType',
					valueField: 'value',
					displayField: 'value',
					allowBlank: false,
					typeAhead:true,
					forceSelection:true
				}]	
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{ 
		    		xtype : 'datefield',
		    		name : 'periodStartDate',
		    		itemId:'periodStartDate',
		    		fieldLabel: getFeeAndPaymentCommonTranslation('PERIOD_START_DATE'),
		    		endDateField : 'billingDate',
		    		listeners: {
		    			render: function(field) {
		    				return dateFormatRender(field);
		    			}
		    		},
		    		//--submitFormat : CONSTANTS.DATE_FORMAT,
		    		vtype : 'daterange'
		    	},{
		    		xtype : 'datefield',
		    		name : 'billingDate',
		    		itemId : 'billingDate',
		    		fieldLabel: getFeeAndPaymentCommonTranslation('BILLING_DATE'),
		    		startDateField : 'periodStartDate',
		    		listeners: {
		    			render: function(field) {
		    				return dateFormatRender(field);
		    			}
		    		},
		    		//--submitFormat : CONSTANTS.DATE_FORMAT,
		    		vtype : 'daterange'
		    	}]		
    	},{
    		xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{ 
					xtype: 'numberfield',
					name: 'dueDays',
					itemId:'dueDays',
					minValue:1,
					hideTrigger:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DAYS'),
					allowBlank:false
				},{
					xtype: 'datefield',
					name: 'dueDate',
					itemId:'dueDate',
					fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					editable:false
				}]	
		},{
			xtype: 'datefield',
			name: 'lastBilledDate',
			itemId:'lastBilledDate',
			width: 256,
			fieldLabel: getFeeAndPaymentCommonTranslation('LAST_BILLING_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:false
		},{	
			xtype:'fieldcontainer',
			width:'100%',
		    cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'btnAdd',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});