/**
 *  @author dharmendra.p
 */


Ext.define('Academia.view.feeandpayment.ViewAccountStatementGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.viewaccountstatementgrid',
	store : 'feeandpayment.dashboardAndReports.ViewAccountStatementReportGrid',
	title: getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT'),
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	width:'100%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
        ftype: 'summary',
        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    }],
	tbar: [{
		xtype: 'button',
		itemId: 'btnPrint',
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
/*	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },*/
	columns: [{
		header : getFeeAndPaymentCommonTranslation('DATE'),
		dataIndex : 'voucherDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		},
		summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_NUMBER'),
		dataIndex : 'voucherNo',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
		dataIndex : 'voucherType',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('LEDGER_NAME'),
		dataIndex : 'ledgerName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PERTICULARS'),
		dataIndex : 'perticulars',
		flex:2
	},{
		header : getFeeAndPaymentCommonTranslation('DEBIT'),
		dataIndex : 'debit',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CREDIT'),
		dataIndex : 'credit',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex : 'balanceAmount',
		flex:1,
		summaryType: 'max',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				var mssg;
				var balance=0;
				/*if(row > 0){
					balance = record.store.getAt(row-1).get('balanceAmount');
				}
				var debit = record.get('debit');
				var credit = record.get('credit');
				var totalAmunt =  parseInt(balance) + parseInt(debit) - parseInt(credit) ;
				record.set('balanceAmount',totalAmunt);
				*/
				if(value>0){
					mssg = 'Dr';
				}else{
					mssg = 'Cr';
				}
				if(row<0){
					mssg='Dr';
				}
				return currencyRenderer(value,record.get("currencyId"))+' '+mssg;
			}
		},
        summaryRenderer: function(value, summaryData, dataIndex) {
        	if(!isNullOrEmpty(value)){
				
        		var store = this.getStore();
        		if(!isNullOrEmpty(store)){
        			var arrStoreItems = store.data.items;
                	var lastRecord = arrStoreItems[arrStoreItems.length-1];
                	if(lastRecord.get("balanceAmount")>0){
    					mssg = 'Dr';
    				}else{
    					mssg = 'Cr';
    				}
    				
                	if(!isNullOrEmpty(lastRecord)){
                		
                			return currencyRenderer(lastRecord.get("balanceAmount"),lastRecord.get("currencyId"))+" "+mssg;
                	} else {
                		return "";
                	}
        		}
			} else {
				return "";
			}
        }
	}]
});
