/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.accountingConfiguration.AccountingConfigurationForm',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.accountingconfigurationform',
	frame: true,
	method: 'POST',
	autoScroll: true,
	layout:'anchor',
	cls:'panelNoSpace horizontalScrollingFixed x-form-fixed-footer-parent',
	style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'hidden',
		name: 'id'
	},/*{
		xtype:'hidden',
		name:'currency',
		itemId:'currency'
	},*/{
		xtype:'hidden',
		name:'createdById',
		itemId:'createdById'
	},{
		xtype:'hidden',
		name:'importId',
		itemId:'importId'
	},{
		xtype:'hidden',
		name:'batchId',
		itemId:'batchId'
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		itemId:'userfieldId',
		hidden:true,
		defaults: {
			width: 256,
			labelAlign: 'top',
			xtype: 'displayfield',
			submitValue:true
		},
		items:[{
			name: 'createdBy',
			itemId:'createdBy',
			fieldLabel: getFeeAndPaymentCommonTranslation('CREATED_BY')
		},{
			name: 'createdDate',
			itemId:'createdDate',
			fieldLabel: getFeeAndPaymentCommonTranslation('CREATED_DATE')
		}]

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top',
			allowBlank:false
		},
		items:[{
			xtype: 'textfield',
			name: 'configName',
			maxLength:100,
			itemId:'configName',
			fieldLabel: getFeeAndPaymentCommonTranslation('CONFIGURATION_NAME')
		},{
			xtype: 'datefield',
			name: 'validTill',
			itemId:'validTill',
			fieldLabel: getFeeAndPaymentCommonTranslation('VALID_TILL'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:false
		}]
	},{
		xtype: 'textarea',
		width: 536,
		name: 'configDesc',
		itemId:'configDesc',
		maxLength:255,
		allowBlank:false,
		fieldLabel: getFeeAndPaymentCommonTranslation('CONFIGURATION_DESCRIPTION')
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
			//cls: 'panelNoSpace'
		},
		items:[{
			xtype : 'customcombobox',
			name : 'batchMode',
			itemId:'batchModeId',
			fieldLabel : getFeeAndPaymentCommonTranslation('BATCH_POSTING_MODE'),
			store : 'feeandpayment.accountingConfiguration.BatchMode',
			valueField : 'id',
			displayField : 'value',
			allowBlank:false
		/*},{
			xtype:'panel',
			items:[{
				xtype: 'radiogroup',
				labelAlign:'top',
				itemId:'batchModeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH_POSTING_MODE'),
				columns: 2,
				flex:1,
				vertical: false,
				items: [
				        { boxLabel:getFeeAndPaymentCommonTranslation('INDIVIDUAL_POSTING'), name: 'batchMode', inputValue: getFeeAndPaymentCommonTranslation('INDIVIDUAL') ,checked:true },
				        { boxLabel:getFeeAndPaymentCommonTranslation('CONSOLIDATE_POSTING'), name: 'batchMode', inputValue: getFeeAndPaymentCommonTranslation('CONSOLIDATE')}
				        ]
			}]*/
		},{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				labelAlign:'top',
				vertical: true,
				itemId:'modeOfTransactionId',
				fieldLabel: getFeeAndPaymentCommonTranslation('TRANSECTION_MODE'),
				column:2,
				items:[
				       { boxLabel: getFeeAndPaymentCommonTranslation('REAL_TIME'), name: 'modeOfTransaction', inputValue: getFeeAndPaymentCommonTranslation('REAL_TIME_VALUE'),checked : true },
				       { boxLabel: getFeeAndPaymentCommonTranslation('BATCH'), name: 'modeOfTransaction', inputValue: getFeeAndPaymentCommonTranslation('BATCH_VALUE')}
				       ]
			}]
		}]
	},{
		xtype: 'checkboxgroup',
		hidden:true,
		itemId:'accountConfigurationBatchSchedulesId',
		fieldLabel: getFeeAndPaymentCommonTranslation('BATCH_POSTING_DAY'),    
		width:'100%',    
		items:[{
			boxLabel:getFeeAndPaymentCommonTranslation('MONDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('TUESDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('WEDNESDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('THURSDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('FRIDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('SATURDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('SUNDAY'),
			name:'batchPostingDay',
			inputValue : true,
			uncheckedValue: false 
		}]	
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
			//cls: 'panelNoSpace'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'currency',
			itemId:'currency',
			fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
			store: 'feeandpayment.AccountingConfigCurrencyStore',
			valueField: 'id',
			displayField: 'name',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false
		},{
			xtype: 'radiogroup',
			itemId:'whetherDataImportEnableId',
			fieldLabel: getFeeAndPaymentCommonTranslation('IMPORT_DATA'),
			column:2,
			items:[
			       { boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherDataImportEnable', inputValue: true},
			       { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherDataImportEnable', inputValue: false,checked : true}
			       ]
		}]
	},{
		xtype: 'checkboxgroup',
		hidden:true,
		itemId:'accountConfigurationImportSchedulesId',
		fieldLabel: getFeeAndPaymentCommonTranslation('IMPORTING_DAY'),    
		width:'100%',    
		items:[{
			boxLabel:getFeeAndPaymentCommonTranslation('MONDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('TUESDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('WEDNESDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('THURSDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('FRIDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('SATURDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		},{
			boxLabel:getFeeAndPaymentCommonTranslation('SUNDAY'),
			name:'importingDay',
			inputValue : true,
			uncheckedValue: false 
		}]
	},{
		xtype:'fieldcontainer',
		width:'auto',
		cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'ResetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
