/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.adjustment.AdjustmentFilters',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.adjustmentfilters',
	autoScroll: true,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	width: '100%',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls:'customSearchPanel adjustmentfiltersCls',
	items: [{
		xtype:'panel',
		cls:'customSearchInnerPanel adjustmentfiltersCls',
		frame: false,
		width:'100%',
		items:[{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'adjustmentFor',
				itemId:'adjustmentFor',
				fieldLabel: getFeeAndPaymentCommonTranslation('ADJUSTMENT_FOR'),
				store:'feeandpayment.adjustment.AdjustmentFor',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'adjustment',
				itemId:'adjustment',
				fieldLabel: getFeeAndPaymentCommonTranslation('ADJUSTMENT_OF'),
				store:'feeandpayment.voucherMode.VoucherLinkType',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'showAllSettlement',
				itemId:'showAllSettlementId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SHOW_SETTLEMENTS'),
				store:'feeandpayment.adjustment.AdjustmentStatus',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
	            xtype: 'customcombobox',
	            name: 'fnpBrandCampusName',
	            itemId: 'fnpBrandCampusItemId',
	            fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
	            valueField: 'id',
				displayField: 'value',
				store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
	  			width: 536,
	  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				queryParam:'qry',
				typeAhead:false,
				hideTrigger:false,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code}' +
	                        '</div>';
	                }
	            }
			},{
				xtype: 'checkboxfield',
	            name: 'inActiveStudent',
	            itemId:'inActiveStudentItemId',
	            labelAlign: 'right',
	            style:{
	            	marginTop:'25px !important',
	            	marginLeft:'3px !important'
	            },
	            boxLabel: getCommonTranslation('INACTIVE_STUDENT'),
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				//	width: 536
			},
			items:[{
				xtype: 'customcombobox',
				name: 'thirdParty',
				itemId:'thirdParty',
				hidden:true,
				width: 256,
				fieldLabel: getFeeAndPaymentCommonTranslation('SEARCH_THIRD_PARTY'),
				store: 'feeandpayment.managebill.ThirdParties',
				valueField: 'id',
				displayField: 'firstName',
				queryParam:'codeOrPrintName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{firstName} {lastName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sponsors',
				itemId:'sponsors',
				hidden:true,
				width: 256,
				fieldLabel: getFeeAndPaymentCommonTranslation('SEARCH_SPONSOR'),
				//store: 'feeandpayment.managebill.Sponsors',
				store:'sponsorship.SponsorsListForSuspenseStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'sponsorNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode}/{sponsorName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				hidden:true,
				width: 256,
				fieldLabel: getFeeAndPaymentCommonTranslation('SEARCH_APPLICANT'),
				store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'user',
				itemId:'userId',
				hidden:true,
				width: 256,
				fieldLabel: getFeeAndPaymentCommonTranslation('SEARCH_USER'),
				store: 'feeandpayment.managebill.User',
				valueField: 'id',
				displayField: 'nameToBePrinted',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{nameToBePrinted}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width: 256,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				queryCaching: false, 
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'receiptNo',
				itemId:'receiptNoId',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
				store:'feeandpayment.adjustment.ReceiptNoSmartSearch',
				valueField: 'id',
				displayField: 'value',
				triggerAction: 'all',
				hidden:true,
	            forceSelection: true,
	            disabled:true,
	            width: 256,
	            //allowBlank: false,
	            queryParam:'receiptNo',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'billNo',
				itemId:'billNoId',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_NO'),
				store:'feeandpayment.adjustment.BillNoSmartSearch',
				valueField: 'id',
				displayField: 'value',
				triggerAction: 'all',
				hidden:true,
	            forceSelection: true,
	            disabled:true,
	            width: 256,
	            //allowBlank: false,
	            queryParam:'billNo',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'paymentNo',
				itemId:'paymentNoId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_NO'),
				store:'feeandpayment.adjustment.PaymentNoSmartSearch',
				valueField: 'id',
				displayField: 'value',
				triggerAction: 'all',
				hidden:true,
	            forceSelection: true,
	            disabled:true,
	            width: 256,
	            //allowBlank: false,
	            queryParam:'paymentNo',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'instrumentNumber',
				itemId:'instrumentNumberId',
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
				store:'feeandpayment.adjustment.InstrumentDetailSmartSearchStore',
				valueField: 'id',
				displayField: 'value',
				triggerAction: 'all',
				hidden:true,
	            forceSelection: true,
	            disabled:true,
	            width: 256,
	            //allowBlank: false,
	            queryParam:'instrumentNo',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'checkboxfield',
				name: 'settleWithCheckBox',
				itemId:'settleWithCheckBoxId',
				labelAlign: 'right',
				hidden:true,
				style:{
					marginTop:'25px !important'
				},
				boxLabel: getCommonTranslation('SETTLE_WITH_PAYMENT'),
			}]

		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout : 'hbox',
			items: [{
				xtype: 'radiogroup',
				itemId: 'manageSettlementCurrency',
				name:'manageSettlementCurrency',
				labelAlign:'top',
				flex: 1,
				vertical: false,
				allowBlank : false,
				//width: 536,
				layout: 'hbox',
				items: [{
					boxLabel: getFeeAndPaymentCommonTranslation('PERFORM_SETTELEMENT_IN_CREATED_CURRENCY'),
					itemId: 'currencyCreated',
					name: 'currencyType',
					inputValue: true,
					checked: true
				},{
					boxLabel: getFeeAndPaymentCommonTranslation('PERFORM_SETTELEMENT_IN_BASE_CURRENCY'),
					itemId: 'baseCurrency',
					name: 'currencyType',
					inputValue: false
				}]
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
    		layout : 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				ui: 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//},{
		
		/*xtype:'receiptslist',
		width:'100%',
		itemId:'receiptslist' 	

	},{
		xtype:'paymentslist',
		hidden:true,
		width: '100%',
		itemId:'paymentslist'
	},{
		xtype:'billlist',
		hidden:true,
		width: '100%',
		itemId:'billlist'
	},{
		xtype:'fieldcontainer',
		itemId:'receiptAdjustment',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		items:[{
			xtype:'instumentdetailslist',
			flex : .4
		},{
			xtype:'billreceivablelist',
			itemId:'billreceivablelist',
			flex : .6
		}]*/
	}]
});