/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.feeandpayment.adjustment.AdjustmentTabStructure' ,{
	extend: 'Ext.tab.Panel',
	alias : 'widget.adjustmenttabstructure',
	autoScroll: true,
    width:'100%',
	plain: true,
	border:true,
	items:[{
		xtype:'container',
		itemId:'listcontainer',
		title: getFeeAndPaymentCommonTranslation('RECEIPT_PAYMENT_BILL'),
		items:[{
			xtype:'receiptslist',
			itemId:'receiptslist'
		},{
			xtype:'paymentslist',
			itemId:'paymentslist',
			hidden:true
		},{
			xtype:'billlist',
			itemId:'billlist',
			hidden:true
		}],
		listeners: {
					activate: function(me, eOpts){
						var  receiptPaymentContentPanelMain = me.up('adjustmentform');
						if(!isNullOrEmpty(receiptPaymentContentPanelMain))
						{
							receiptPaymentContentPanelMain.down('panel').scrollBy(0,1);
							receiptPaymentContentPanelMain.down('panel').scrollBy(0,-1);
						}
						
					}
				}
	},{
		xtype:'container',
		itemId:'instumentdetailscontainer',
		disabled:true,
		title: getFeeAndPaymentCommonTranslation('INSTUMENT_DETAILS'),
		items:[{
			xtype:'fieldcontainer',
			layout:'vbox',
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				style:{marginLeft:'38px',marginTop:'10px'},
				defaults: {
					width: 150,
					labelAlign: 'top',
					xtype: 'displayfield'
				},
				items:[{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
					itemId:'receipt_no',
					cls: 'text-wrapper',
					width: 200
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
					itemId:'recipt_amount'
				}]
			}]
		},{
			xtype:'instumentdetailslist',
			itemId:'instumentdetailslist'
		}],
		listeners: {
			activate: function(me, eOpts){
				var  instumentDetailsContentPanelMain = me.up('adjustmentform');
				if(!isNullOrEmpty(instumentDetailsContentPanelMain))
				{
					setTimeout(function(){
						instumentDetailsContentPanelMain.down('panel').scrollBy(0,1);
						instumentDetailsContentPanelMain.down('panel').scrollBy(0,-1);
					},500);
				}
			}
		}
	},{
		xtype:'container',
		itemId:'allbilllistcontainer',
		disabled:true,
		title: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
		items:[{
			xtype:'fieldcontainer',
			layout:'vbox',
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				style:{marginLeft:'38px',marginTop:'10px'},
				defaults: {
					width: 200,
					labelAlign: 'top',
					xtype: 'displayfield'
				},
				items:[{
					xtype:'hidden',
					itemId:'receiptCurrency',
					name: 'receiptCurrency',
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
					itemId:'receipt_bill_no_ab',
					cls: 'text-wrapper',
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
					itemId:'receipt_bill_amount_ab',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					itemId:'instrument_no_ab',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_AMOUNT'),
					itemId:'instrument_amount_ab',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('AVAILABLE_AMOUNT'),
					itemId:'recipt_bill_balance_amount_ab',
					width: 180
				}]
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				style:{marginLeft:'15px'},
				defaults: {
					width: 950,
					labelAlign: 'top'
				},
				items : [{
		            xtype: 'multiselectcombofield',
		            name: 'fnpMultiBrandCampusNameAdjustment',
		            itemId: 'fnpMultiBrandCampusAdjustmentItemId',
		            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
		            valueField: 'id',
					displayField: 'value',
					store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
		  			cls:'multiBrandCampusCls',
		  			typeAhead: true,
		            allowBlank:false,
		            forceSelection: true,
		            listConfig: {
		                listeners: {
		                    beforeshow: function(picker) {
		                        picker.minWidth = picker.up('combobox').getSize().width;
		                    }
		                },
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code}' +
		                        '</div>';
		                }
		            }
				}]
			},
				{
					xtype:'fieldcontainer',
					layout:'hbox',
					style:{marginLeft:'15px'},
					defaults: {
						width: 950,
						labelAlign: 'top'
					},
				items:[{
					xtype : 'multiselectcombofield',
					name : 'studentName',
					itemId:'studentNameId',
					autoloadStore: false,
					//width: 560,
					fieldLabel : getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store:'feeandpayment.adjustment.StudentDetailsByStudentCodeForSponsorStore',
					valueField : 'id',
					displayField : 'valueCode',
					queryParam:'studentNameOrCode',
					minChars:3,
					typeAhead:true,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					hidden:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							},
							afterRender: function(combo){
								combo.getStore().on("load", function(store, items){
									if(items.length==0)
										Ext.select('.x-boundlist-item').elements[0].hidden = true;
									else
										Ext.select('.x-boundlist-item').elements[0].hidden = false;
								});
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
					}
				}]
			},{
				xtype:'fieldcontainer',
				width: '100%',
				style:{marginLeft:'15px'},
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'studentSearchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					hidden:true,
					formBind:true,
					scale: CONSTANTS.BUTTONSIZE               
				}/*,{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'resetBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}*/]	
			
			}]
		},{
			xtype:'allbillslist',
			itemId:'allBillsList'
		}],
		listeners: {
			activate: function(me, eOpts){
				var  allBillsListContentPanelMain = me.up('adjustmentform');
				if(!isNullOrEmpty(allBillsListContentPanelMain))
				{
					allBillsListContentPanelMain.down('panel').scrollBy(0,1);
					allBillsListContentPanelMain.down('panel').scrollBy(0,-1);
					var adjustmentstructure = allBillsListContentPanelMain.down('adjustmentstructure');
					var adjustmentfilters = adjustmentstructure.down('adjustmentfilters');
					var adjustmentForField = adjustmentfilters.down('#adjustmentFor');
					var adjustmentTabStructure = adjustmentstructure.down('adjustmenttabstructure');
					var sponsorsValue = adjustmentstructure.down('#sponsors');
					var id=0;
					if(!sponsorsValue.isHidden()){
            				  id = sponsorsValue.getValue();
            			  }

                           if(!sponsorsValue.isHidden()){
     	                	   Ext.Ajax.request({
    	                		   method: "GET",
    	                		   type: 'rest',
    	                		   url: SERVERURL.SPONSORSHIP_URL,
    	                		   params: {
    	                			   id: id
    	                		   },
    	                		   success: function(f, action) {
    	                			   var responseData = Ext.JSON.decode(f.responseText);
    	                			   var sponsorsIsSuspenseAccount = responseData.isSuspenseAccount;
    	                			   if(!sponsorsValue.isHidden()&& sponsorsIsSuspenseAccount == false && !isNullOrEmpty(sponsorsIsSuspenseAccount)){
    	                			   							
					

     	                	   
    	                			   							
					

     	                	   
    	                			   							
					if(adjustmentForField.getValue() == 'SPONSOR' && sponsorsIsSuspenseAccount == true){
						adjustmentTabStructure.down('#studentNameId').setVisible(true);
						adjustmentTabStructure.down('#studentSearchBtn').setVisible(true);
						//adjustmentTabStructure.down('#fnpMultiBrandCampusAdjustmentItemId').setVisible(true);
					}else{
						adjustmentTabStructure.down('#studentNameId').setVisible(false);
						adjustmentTabStructure.down('#studentSearchBtn').setVisible(false);
						adjustmentTabStructure.down('#fnpMultiBrandCampusAdjustmentItemId').setVisible(true);
					}	  
    	                			   }
    	                		   }
    	                	   });
           					}
				}
			}
		}
	},{
		xtype:'container',
		itemId:'billreceivablecontainer',
		disabled:true,
		title: getFeeAndPaymentCommonTranslation('FEE_HEAD_COVERED'),
		items:[{
			xtype:'fieldcontainer',
			layout:'vbox',
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				style:{marginLeft:'38px',marginTop:'10px'},
				defaults: {
					width: 200,
					labelAlign: 'top',
					xtype: 'displayfield'
				},
				items:[{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
					itemId:'receipt_bill_no',
					cls: 'text-wrapper',
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
					itemId:'receipt_bill_amount',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					itemId:'instrument_no',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('INSTRUMENT_AMOUNT'),
					itemId:'instrument_amount',
					width: 200,
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('AVAILABLE_AMOUNT'),
					itemId:'recipt_bill_balance_amount',
					width: 180
				}]
			}]
		},{
			xtype:'billreceivablelist',
			itemId:'billreceivablelist'
		}],
		listeners: {
			activate: function(me, eOpts){
				var  billReceivableListContentPanelMain = me.up('adjustmentform');
				if(!isNullOrEmpty(billReceivableListContentPanelMain))
				{
					billReceivableListContentPanelMain.down('panel').scrollBy(0,1);
					billReceivableListContentPanelMain.down('panel').scrollBy(0,-1);
				}
				
			}
		}
	},{
		xtype:'container',
		itemId:'paymentReceiptSetttlementcontainer',
		disabled:true,
		title: getFeeAndPaymentCommonTranslation('PAYMENT_RECEIPT_SETTLEMENT'),
		items:[{
			xtype:'fieldcontainer',
			layout:'vbox',
			items:[{
				xtype:'fieldcontainer',
				layout:'hbox',
				style:{marginLeft:'15px'},
				defaults: {
					width: 200,
					labelAlign: 'top',
					xtype: 'displayfield'
				},
				items:[{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
					itemId:'receiptNumId',
					cls: 'text-wrapper',
					hidden:true
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT'),
					itemId:'receiptAmountId',
					hidden:true
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_NO'),
					itemId:'paymentNumId'
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('PAYMENT_AMOUNT'),
					itemId:'paymentAmountId'
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('AVAILABLE_AMOUNT'),
					itemId:'receiptPaymentBalanceAmountId'
				}]
			}]
		},{
			xtype:'paymentslistforreceiptsettlement',
			itemId:'paymentsListForReceiptSettlement'
		},{
			xtype:'receiptslistforpaymentsettlement',
			itemId:'receiptsListForPaymentSettlement',
			hidden:true
		}],
		listeners: {
			activate: function(me, eOpts){
				var  form = me.up('adjustmentform');
				if(!isNullOrEmpty(form)){
					form.down('panel').scrollBy(0,1);
					form.down('panel').scrollBy(0,-1);
				}
			}
		}
	}]
});

