/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.feeandpayment.adjustment.BillReceivableGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.billreceivablegridwindow',
	modal : true,
	resizable:true,
	autoScroll: false,
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('BILL_ADJUSTMENTS'),
	items: [{
		xtype: 'grid',
   	    itemId:'receiptviewgrid',
	    store : 'feeandpayment.payment.ReceiptAndPaymentDetails',
		autoScroll: false,
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.payment.ReceiptAndPaymentDetails',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
	    }],
		columns: [{
		        	header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		     		dataIndex : 'billNo',
		     		flex : 1	 
		         },{
		        	 header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
			     	 dataIndex : 'adjustmentDate',
			     	 flex : 1,
			 		 renderer:function(date) {
						return dateRender(date);
					 }
		         },{
		        	 header : getFeeAndPaymentCommonTranslation('VOUCHER_MODE'),
			     	 dataIndex : 'voucherMode',
			     	 flex : 1	
		         },{
		        	 header : getFeeAndPaymentCommonTranslation('VOUCHER_TYPE'),
			     	 dataIndex : 'voucherType',
			     	 flex : 1
		         },{
		        	 header : getFeeAndPaymentCommonTranslation('FEE_ADJUSTED_AMOUNT'),
			     	 dataIndex : 'feeAdjustedAmount',
			     	 flex : 1
		         },{
		        	 header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
			     	 dataIndex : 'billingDate',
			     	 flex : 1,
			 		 renderer:function(date) {
						return dateRender(date);
					 }
		         }] 	
		
	}]
});
