/**
 * @author Deepika Parmar

 */
var gridStore = Ext.create('Academia.store.feeandpayment.coursefeedefinition.CourseFeeDefinitionListStore');
Ext.define('Academia.view.feeandpayment.coursefeedefinition.CourseFeeDefinitionSeachGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.coursefeedefinitionseachgrid',
	title: getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_LIST'),
	store: gridStore,
	border: true,
	style: {marginBottom: '30px !important'},
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,

	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: gridStore,
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.1,
		sortable: false

	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('FEES_COURSE_FEE_DEFINITION'),
		dataIndex: 'courseDefinationName',
		flex:.1,
		sortable: false
	},{
		header:  getCommonTranslation('FEE_TYPE'),
		dataIndex: 'courseFeeTypeName',
		flex:.1,
		sortable: false,
		renderer : function(value){
			if(value=='FIXED'){
				return 'Fixed Amount';
			}else{
				return 'Credit Based';

			}
		}
	},{
		header:  getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex: 'totalAmount',
		flex:.1,
		sortable: false,
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				if(record.get('courseFeeTypeName') == "CREDIT_BASED" || record.get('courseFeeTypeName') =="Credit Based" ){
					return null;
				}
				else {

					return value;
				}
			}
		}

	},{
		header:  getCommonTranslation('FEE_HEAD'),
		dataIndex: 'parentFeeHeadName',
		flex:.1,
		sortable: false

	},{
		header:  getCommonTranslation('DEFAULT_FEE_DEFINITION'),
		dataIndex: 'isDefaultFeeDefinition',
		flex:.1,
		sortable: false,
		renderer : function(value){
			if(value == true){
				return "True";
			}else if(value == false){
				return "False";
			}
			else{
				return "False"
			}
		}

	},{
		header:  getCommonTranslation('FEE_SUBHEADS'),
		dataIndex: 'subHeadCount',
		flex:.1,
		sortable: false,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}

	},{header:  getCommonTranslation('STATUS'),
		dataIndex: 'isActive',
		flex:.1,
		sortable: false,
		renderer : function(value){
			if(value){
				return '<div style="color:green;">'+getCommonTranslation('ACTIVE')+'</div>';
			}else{
				return '<div style="color:red;">'+getCommonTranslation('INACTIVE')+'</div>';

			}
		}}]
});
