/**
 *  @author Deepika Parmar
 * 
 */
Ext.define('Academia.view.feeandpayment.coursefeedefinition.CourseRepetitionConfigurationTab' ,{
	extend : 'Ext.panel.Panel',
	alias : 'widget.courserepetitionconfigurationtab',
	
	style:{
		border:'none'
	},
	itemId:'courserepetitionconfigurationtabItemId',
	autoScroll: false,
	items:[{
		
		xtype:'grid',
		border:true,
		store : 'feeandpayment.coursefeedefinition.CourseRepetitionStore',
		itemId:'courserepetitionconfigurationGridId',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS,
			
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'feeandpayment.coursefeedefinition.CourseRepetitionStore',
				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		tbar: [{
			xtype: 'button',
			itemId: 'btnAdd',
			tooltip: getCommonTranslation('ADD'),
			iconCls:'icon-addbutton',
			cls:'addbutton'
		}, {
			xtype: 'button',
			itemId: 'btnEdit',
			tooltip: getCommonTranslation('EDIT'),
			iconCls:'icon-editbutton',
			cls:'editbutton'
		}/*, {
			xtype: 'button',
			itemId: 'btnView',
			tooltip: getCommonTranslation('VIEW'),
			  iconCls: 'icon-View',
				cls:'iconView',
		}*/, {
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'),
			 iconCls: 'icon-Delete',
				cls:'iconDelete',
		}],
		columns: [{
			header:  getFeeAndPaymentCommonTranslation('COURSE_ENROLLMENT_NO'),
			dataIndex: 'enrollmentNo',
			flex:.1,
		    sortable: false,
		   
		},{
			header:  getFeeAndPaymentCommonTranslation('STATUS'),
			dataIndex: 'isActive',
			flex:.1,
		    sortable: false,
		    renderer : function(value){
				if(value){
					return getCommonTranslation('ACTIVE');
				}else{
					return getCommonTranslation('INACTIVE');

				}
		    }
		},{
			header:  getFeeAndPaymentCommonTranslation('VIEW_DEFINITION'),
			dataIndex: 'subHeadCount',
			flex:.1,
		    sortable: false,
		    renderer:function(value){
				if(value>0){
					return  '<a href="#">'+value+'</a>';
				}else{
					return value;
				}
			}
		},{
			
			header:  getCommonTranslation('FOR_ALL_ENROLLMENTS'),
			dataIndex: 'isForAllEnrollment',
			flex:.1,
		    sortable: false,
		    renderer:function(value){
				if(value == true || value == 'true'){
					return  'Yes';
				}else{
					return 'No';
				}
			}
		}]
	}]
});

