/**
 * Bhanu PS
 */
Ext.define('Academia.view.feeandpayment.discounts.AddDiscount', {
	extend: 'Ext.window.Window',
	alias: 'widget.adddiscount',
	modal: true,
	autoScroll:true,
	title: getFeeAndPaymentCommonTranslation('DISCOUNT_MASTER_ADD'),
	maxHeight:500,
	width: 700,
	height:400,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		/*layout: {
			type: 'vbox'
		},*/
		defaults: {
			labelAlign: 'top',
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 200,
				labelAlign:'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'discountType',
				itemId:'discountTypeItemId',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
				store: 'feeandpayment.discount.DiscountTypeStore',
				valueField: 'id',
				displayField: 'code',
				editable: false,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'textfield',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
				name: 'discountCode',
				itemId: 'discountCodeItemId',
				allowBlank:false
			},{
				xtype: 'textfield',
				fieldLabel: getExaminationTranslation('DESCRIPTION'),
				name: 'description',
				itemId: 'descriptionItemId',
				allowBlank:false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 200
			},
			items: [{
            	xtype: 'customcombobox',
                name: 'discountCurrency',
                itemId : 'discountCurrency',
                fieldLabel: getCommonTranslation('DISCOUNT_CURRENCY'), //Currency Name
                store: 'othermasters.currencymaster.CurrencyMasterFindALLCurrenciesStore',
                valueField: 'id',
                displayField: 'name',
                editable: false,
                labelAlign: 'top',
                allowBlank: false
            },{
				xtype: 'customcombobox',
				name:'drools',
				itemId:'droolsItemId',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
				fieldLabel:getFeeAndPaymentCommonTranslation('RULE_APPLICABLE'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
				disabled:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				queryParam:'droolName',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256,
			},
			items:[{
				xtype: 'checkboxfield',
				width: 'auto',
				style:{marginTop:'20px'},
				itemId:'percentageItemId',
				labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_PERCENTAGE'),
				name: 'percentage',
				inputValue : true,
				uncheckedValue: false 
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				style:{marginTop:'20px'},
				itemId:'fixedItemId',
				labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_FIXED'),
				name: 'fixed',
				inputValue : true,
				uncheckedValue: false 
			}]
		}, {
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256,
			},
			items:[{
				xtype: 'checkboxfield',
				width: 'auto',
				style:{marginTop:'20px'},
					itemId:'adhocItemId',
					labelAlign: 'left',
					boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_ADHOC'),
					name: 'adhoc',
					inputValue : true,
					uncheckedValue: false 
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				style:{marginTop:'20px',marginLeft:'31px'},
				itemId:'standAloneItemId',
				labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('WHETHER_STANDALONE'),
				name: 'standAlone',
				inputValue : true,
				uncheckedValue: false 
			},{
				xtype: 'textfield',
				itemId:'checkWhetherCheckboxEmpty',
				allowBlank: false,
				hidden:true,
				name: 'checkWhetherCheckboxEmpty'
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]
});