/**
 *  @author Amit G
 */

Ext.define('Academia.view.feeandpayment.discounts.DiscountMapFeeHeadGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.discountmapfeeheadgrid',
	title : 'Map Fee Head',
	store: 'feeandpayment.discount.DiscountFeeHeadMappingListStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.discount.DiscountFeeHeadMappingListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'submitBtn',
		text:getCommonTranslation('SUBMITKYS'),
		tooltip: getCommonTranslation('SUBMITKYS')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
				xtype: 'customcombobox',
				name: 'feePlanNametext',
				itemId: 'feePlanNametext',
				width:260,
				store:Ext.create('Academia.store.feeandpayment.discount.DiscountMasterFeePlanListStore'),
				displayField:'value',
				valueField:'value',
				typeAhead:true,
				forceSelection:true,
				style: {
					marginRight: '8px !important'
				},
				hideTrigger:false,	    
				triggerAction: 'all',
				minChars:3,
				queryParam:'feePlanNametext',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},
				
				/*{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [*/{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			//ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		}/*]	
	}*/
				
	],
	columns: [{
		header : getCommonTranslation('FEE_PLAN_NAME'),
		dataIndex : 'feePlanName',
		flex : 1	 
	},{
		header : getCommonTranslation('FEE_PLAN_TYPE'),
		dataIndex : 'feePlanType',
		flex : 1,
		hidden:true
	},{
		header : getFeeAndPaymentCommonTranslation('RULE_DISCRIPTION'),
		dataIndex : 'feeRuleDesc',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('STAGE_NAME'),
		dataIndex : 'stageName',
		flex : 1	 
	},{
		header : getCommonTranslation('FEE_HEAD_NAME'),
		dataIndex : 'feeHeadName',
		flex : 1	 
	}]
});