/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.discounts.ManageDiscountFilter',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.managediscountfilter',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		//width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{		
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'multiselectcombofield',
				width: 698,
				name : 'manageDiscountAcademyLoc',
				itemId:'manageDiscountAcademyLocId',
				fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
				store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
				allowBlank : false,
				height:58,
	  			cls:'multiBrandCampusCls',
	  			style :{
	  				marginLeft: '6px'
	  			},
	  			matchFieldWidth:true,
	  			maxLength:15000,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')				
				}]
			
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'userType',
			itemId: 'userType',
			store: 'feeandpayment.dashboardAndReports.DiscountFindAllUserTypeStore',
			fieldLabel: getCommonTranslation('USER_TYPE'),
			valueField: 'value',
			displayField: 'value',
			typeAhead: false,
			queryMode : 'local',
			allowBlank : false,
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'feeandpayment.managebill.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Applicant'),
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'discountType',
			itemId:'discountTypeItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
			store: Ext.create('Academia.store.feeandpayment.discount.DiscountMasterListStore'),
			valueField: 'id',
			displayField: 'code',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'appStatus',
			itemId: 'appStatus',
			store:Ext.create('Academia.store.feeandpayment.discount.DiscountStatusStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('STATUS')
		}]

	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_FILTERS'),
		titleCollapse: true,
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
          	 marginTop: '33px!important'
         },
		items:[{
			    xtype: 'fieldcontainer',
			    layout: 'hbox',
			    defaults: {
			        labelAlign: 'top',
			        width: 256
			    },
			    items: [{

			    	xtype: 'customcombobox',
			    	fieldLabel: getFeeAndPaymentCommonTranslation('APPLIED_BY'),
			    	name:'appliedBy',
			    	itemId:'appliedBy',
			    	//store: 'criteriabuilder.userquicksearch.QuickSearchName',
			    	store: 'feeandpayment.discount.UserSmartSearchByUserCode',
			    	msgTarget: 'qtip',
			    	valueField: 'id',
			    	displayField: 'valueCode',
			    	queryParam:'codeOrName',
			    	minChars:3,
			    	typeAhead:false,
			    	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			    	enableKeyEvents  : 'true',
			    	hideTrigger:false,
			    	forceSelection:true,
			    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    	listConfig: {
			    		listeners: {
			    			beforeshow: function(picker) {
			    				picker.minWidth = picker.up('combobox').getSize().width;
			    			}
			    		},
			    		loadingText: getCommonTranslation('SEARCHING'),
			    		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    		getInnerTpl: function() {
			    			return '<div class="search-item">' +
			    			'{code}' +
			    			'</div>';
			    		}
			    	}

			    },{

			    	xtype: 'customcombobox',
			    	fieldLabel: getAdmissionTranslation('APPROVED_BY'),
			    	name:'approvedBy',
			    	itemId:'approvedBy',
			    	store: 'feeandpayment.discount.UserSmartSearchByUserCode',
			    	msgTarget: 'qtip',
			    	valueField: 'id',
			    	displayField: 'valueCode',
			    	queryParam:'codeOrName',
			    	minChars:3,
			    	typeAhead:false,
			    	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			    	enableKeyEvents  : 'true',
			    	hideTrigger:false,
			    	forceSelection:true,
			    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    	listConfig: {
			    		listeners: {
			    			beforeshow: function(picker) {
			    				picker.minWidth = picker.up('combobox').getSize().width;
			    			}
			    		},
			    		loadingText: getCommonTranslation('SEARCHING'),
			    		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    		getInnerTpl: function() {
			    			return '<div class="search-item">' +
			    			'{code}' +
			    			'</div>';
			    		}
			    	}

			    },{xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('INTAKE_YEAR'),
					name : 'intakeYear',
					itemId : 'intakeYear',
					displayField:'value',
					valueField:'id',
					width: 256,
					typeAhead:true,
					forceSelection:true,
					minChars:3,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.IntakeYearStore');
							combo.bindStore(store)
						}
					}
				}]
			    
			
			},  

		{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [
         {
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'common.ProgramByAcademyLocationStore',
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
            hideTrigger:false,	    
    	    triggerAction: 'all',
            minChars:3,
            queryParam:'programName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchId',
			fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:true,
			forceSelection:true
		},{

 			xtype: 'customcombobox',
 			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
 			name: 'seatType',
 			itemId: 'seatType',
 			editable: false,
 			disabled:true,
 			autoload: false,
 			store:'common.SeatTypesByBatchId',
 			valueField: 'seatTypeId',
 			displayField: 'seatTypeName',
 			queryMode : 'local'
 		
         }]
    },{
    	xtype : 'fieldcontainer',
    	width: '100%',
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
    		xtype:'displayfield',
    		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('APPLICABLE_FROM_DATE_RANGE')+'</b>',
    		style: {
    			textDecoration: "underline"
    		}
    	},{ 
    		xtype : 'fieldcontainer',
    		width: '100%',
    		layout:'hbox',
    		defaults : {
    			width: 256,
    			labelAlign : 'top'
    		},
    		items : [{
    			xtype : 'datefield',
    			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
    			name : 'applicableFromDate',
    			itemId:'applicableFromDateId',
    			endDateField : 'applicableToDateId',
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
    			vtype : 'daterange'
    		},{
    			xtype : 'datefield',
    			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
    			name : 'applicableToDate',
    			itemId : 'applicableToDateId',
    			startDateField : 'applicableFromDateId',
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
    			vtype : 'daterange'
    		}]
    	}
    	]},{

        	xtype : 'fieldcontainer',
        	width: '100%',
        	defaults : {
        		width: 256,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype:'displayfield',
        		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('APPROVED_FROM_DATE_RANGE')+'</b>',
        		style: {
        			textDecoration: "underline"
        		}
        	},{ 
        		xtype : 'fieldcontainer',
        		width: '100%',
        		layout:'hbox',
        		defaults : {
        			width: 256,
        			labelAlign : 'top'
        		},
        		items : [{
        			xtype : 'datefield',
        			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
        			name : 'approvedFromDate',
        			itemId:'approvedFromDateId',
        			endDateField : 'approvedToDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		},{
        			xtype : 'datefield',
        			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
        			name : 'approvedToDate',
        			itemId : 'approvedToDateId',
        			startDateField : 'approvedFromDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		}]
        	}
        	]
    	},{

        	xtype : 'fieldcontainer',
        	width: '100%',
        	defaults : {
        		width: 256,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype:'displayfield',
        		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('DISCOUNT_VALIDITY_DATE_RANGE')+'</b>',
        		style: {
        			textDecoration: "underline"
        		}
        	},{ 
        		xtype : 'fieldcontainer',
        		width: '100%',
        		layout:'hbox',
        		defaults : {
        			width: 256,
        			labelAlign : 'top'
        		},
        		items : [{
        			xtype : 'datefield',
        			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
        			name : 'discountValFromDate',
        			itemId:'discountValFromDateId',
        			endDateField : 'discountValToDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		},{
        			xtype : 'datefield',
        			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
        			name : 'discountValToDate',
        			itemId : 'discountValToDateId',
        			startDateField : 'discountValFromDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		}]
        	}
        	]
    	},{

        	xtype : 'fieldcontainer',
        	width: '100%',
        	defaults : {
        		width: 256,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype:'displayfield',
        		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('DISCOUNT_APPLIED_DATE_RANGE')+'</b>',
        		style: {
        			textDecoration: "underline"
        		}
        	},{ 
        		xtype : 'fieldcontainer',
        		width: '100%',
        		layout:'hbox',
        		defaults : {
        			width: 256,
        			labelAlign : 'top'
        		},
        		items : [{
        			xtype : 'datefield',
        			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
        			name : 'discountAppFromDate',
        			itemId:'discountAppFromDateId',
        			endDateField : 'discountAppToDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		},{
        			xtype : 'datefield',
        			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
        			name : 'discountAppToDate',
        			itemId : 'discountAppToDateId',
        			startDateField : 'discountAppFromDateId',
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			},
        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        			vtype : 'daterange'
        		}]
        	}
        	]
    	}]},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			formBind:true,
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});