/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.feerequest.FeeReqSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feereqsearchform',
	frame: false,
	cls:'customSearchPanel',
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'id'
	},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				//xtype:'displayfield',
				xtype:'textfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('REQUEST_CREATED_BY'),
				itemId:'requestCreatedBy',
				hidden:true,
				name:'requestCreatedBy'
			},{
				xtype: 'customcombobox',
				name: 'requestFor',
				itemId:'requestFor',
				fieldLabel: getFeeAndPaymentCommonTranslation('REQUEST_FOR'),
				store: 'feeandpayment.feerequest.FeeRequestFors',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'chooseAgainst',
				itemId:'chooseAgainst',
				fieldLabel: getFeeAndPaymentCommonTranslation('CHOOSE_AGAINST'),
				store: 'feeandpayment.feerequest.ChooseAgainst',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'concessionType',
				itemId:'concessionType',
				fieldLabel: getFeeAndPaymentCommonTranslation('CONCESSION_TYPE'),
				store: 'feeandpayment.feerequest.ConcessionType',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('REQUEST_DATE'),
				itemId:'requestDate',
				name:'requestDate',
				allowBlank:false,
//				value:new Date(),
				maxValue:new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'sponsors',
				itemId:'sponsors',
				hidden:true,
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
				store: 'feeandpayment.managebill.Sponsors',
				valueField: 'id',
				displayField: 'sponsorName',
				queryParam:'sponsorNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{sponsorshipCode}/{sponsorName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'user',
				itemId:'userId',
				hidden:true,
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
				store: 'feeandpayment.managebill.User',
				valueField: 'id',
				displayField: 'nameToBePrinted',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{nameToBePrinted}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width: 536,
				//hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				allowBlank:false,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			}]

		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			hidden:true,
			itemId:'addressDetails',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'displayfield',
				name: 'address',
				itemId:'address',
				fieldLabel: getFeeAndPaymentCommonTranslation('ADDRESS')
			},{
				xtype: 'displayfield',
				name: 'emailId',
				itemId:'emailId',
				fieldLabel: getFeeAndPaymentCommonTranslation('EMAIL')
			},{
				xtype:'displayfield',
				fieldLabel:getFeeAndPaymentCommonTranslation('PHONE_NO'),
				itemId:'contactNo',
				name:'contactNo'
			}]
		},{
			xtype: 'fieldcontainer',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				formBind:true,
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE               
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
	}]
});