/**
 *  @author Amit G
 */


Ext.define('Academia.view.feeandpayment.finance.FinanceHoldBlockedStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.financeholdblockedstudentgrid',
	store : 'feeandpayment.finance.FinanceBlockedStudentGridDataStore',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_BLOCKED_STUDENTS'),
	border: true,
	autoScroll: false,
	frame:false,
	 selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
   selModel: {
		 //showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false
  },
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.finance.FinanceBlockedStudentGridDataStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'unblockBtn',
		text:getFeeAndPaymentCommonTranslation('UNBLOCK'),
		tooltip: getFeeAndPaymentCommonTranslation('UNBLOCK')
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},
	{
		header : getFeeAndPaymentCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PENDING_FEE'),
		dataIndex : 'pendingFee',
		flex:1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return value +'%';
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DUE_FEES_AMOUNT'),
		dataIndex : 'pendingAmount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.data.baseCurrencyId)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}else
			{
				return value;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('HOLD_TYPE'),
		dataIndex : 'financeHoldType',
		flex:1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	}]
});