/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.finance.FinanceHoldTypeWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.financeholdtypewindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('FINANCE_HOLD_TYPES'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.finance.FinanceHoldTypeCountList',
		autoScroll: true,
		itemId : 'billHeaderGridWithPercent',
		hidden:true,
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.finance.FinanceHoldTypeCountList',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('FINANCE_HOLD_TYPE'),
			dataIndex : 'financeHoldType',
			flex : 1,
			renderer:function(value, metaData, record, rowIndex, colIndex, view){
				metaData.style = "white-space: normal;";
				return getCommonTranslation(value);
			}
		},{
			header : getFeeAndPaymentCommonTranslation('MINIMUM_PERCENTAGE_DUE'),
			dataIndex : 'pendingFeePercent',
			flex : 1,
		}] 	

	},{
		xtype: 'grid',
		store : 'feeandpayment.finance.FinanceHoldTypeCountList',
		autoScroll: true,
		hidden:true,
		itemId : 'billHeaderGridWithAmount',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.finance.FinanceHoldTypeCountList',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('FINANCE_HOLD_TYPE'),
			dataIndex : 'financeHoldType',
			flex : 1,
			renderer:function(value, metaData, record, rowIndex, colIndex, view){
				metaData.style = "white-space: normal;";
				return getCommonTranslation(value);
			}
		},{
			header : getFeeAndPaymentCommonTranslation('MINIMUM_DUE_AMOUNT'),
			dataIndex : 'minimumDueAmount',
			flex : 1,
		}] 	

	}]
});
