/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.finance.FinanceMappedProgramWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.financemappedprogramwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('MAPPED_PROGRAMS'),
	items: [{
		xtype: 'grid',
		store : 'feeandpayment.finance.FinanceHoldPBSFindByGridListing',
		autoScroll: true,
		itemId : 'billHeaderGrid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		 features: [{
		        ftype: 'summary',
		        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		    }],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'feeandpayment.finance.FinanceHoldPBSFindByGridListing',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyName',
			flex:1
		},{
			header : getFeeAndPaymentCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex:1
		},{
			header : getFeeAndPaymentCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex:1
		},
		{
			header : getFeeAndPaymentCommonTranslation('PERIOD'),
			dataIndex : 'periodName',
			flex:1
		},{
			header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatName',
			flex:1
		}] 	

	}]
});
