/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.BillDependentDetailsWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.billdependentdetailswindow',
	title:getFeeAndPaymentCommonTranslation('BILL_DEPENDENT_DETAILS'),
	frame: true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '0 0 0 0',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			name:'id'
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'dependentBillType',
				itemId:'dependentBillType',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPENDENT_BILL_TYPE'),
				store:'feeandpayment.managebill.DependentBillType',
				displayField:'value',
				valueField:'id',
				//forceSelection:true,
				//allowBlank:false,
				typeAhead:true,
				width: 256
			},{
				xtype: 'customcombobox',
				name: 'raiseBillCategory',
				itemId:'raiseBillCategory',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
				store:'feeandpayment.managebill.BillCategory',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				typeAhead:true,
				width: 256
			}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'refBillHeader',
				itemId:'refbillheader',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPENDENT_BILL_ID'),
				store:'feeandpayment.managebill.DependentBillId',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				//allowBlank:false,
				typeAhead:true,
				width: 256
			},{
				xtype: 'customcombobox',
				name: 'dependantFeeHead',
				itemId:'dependantFeeHead',
				fieldLabel: getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_HEAD'),
				store:'feeandpayment.DependedFeeHead',
				displayField:'value',
				valueField:'id',
				//forceSelection:true,
				allowBlank:false,
				typeAhead:true,
				width: 256
			}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name: 'feeAmount',
				itemId:'feeAmount',
				minValue:0,
				hideTrigger:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
				allowBlank:false,
				readOnly:true,
				width: 256

			},{
				xtype: 'numberfield',
				name: 'noOfSession',
				itemId:'noOfSession',
				minValue:0,
				hideTrigger:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_AMOUNT'),
				//allowBlank:false,
				hidden:true,
				width: 256
			}]
		},{
			xtype: 'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'CancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]     
});