/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.BillDiscountList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.billdiscountlist',
	store : 'feeandpayment.managebill.DiscountEntry',
	border: true,
//	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.DiscountEntry',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
    	 xtype: 'button',
         itemId: 'btnAdd',
         tooltip: getFeeAndPaymentCommonTranslation('ADD'),
         glyph: ICONGLYPH.ADDGLYPH
     },{
    	 xtype: 'button',
         itemId: 'btnEdit',
         tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
         glyph: ICONGLYPH.EDITGLYPH
     },{
	     xtype: 'button',
         itemId: 'btnView',
         tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
         iconCls: 'view-icon'
     },{
         xtype: 'button',
         itemId: 'btnDelete',
         cls: 'CustomToolbarBtnReject',
         tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
         glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns: [{
	        	header : getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
	     		dataIndex : 'discountCode',
	     		flex : 0.6,
	     		renderer : function(value){
	     			if(value){
	     			    return value.value;
	     			}
	     		}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
		     	 dataIndex : 'discountAmount',
		     	 flex : 0.6,
		     	 renderer:function(value, metaData, record, row, col, store, gridView){
					return currencyRenderer(value,record.get("currencyId"));
				}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_DATE'),
		     	 dataIndex : 'discountDate',
		     	 flex : 0.6,
		     	renderer : function(discountDate){
	     			if(discountDate){
	     			    return dateRender(discountDate);
	     			}
	     		}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_GIVEN_BY'),
		     	 dataIndex : 'discountGivenBy',
		     	 flex : 0.6,
		     	renderer : function(discountGivenBy){
	     			if(discountGivenBy){
	     			    return discountGivenBy.value;
	     			}
	     		}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('DISCOUNT_REMARK'),
		     	 dataIndex : 'reasonForDiscount',
		     	 flex : 0.6,
		     	renderer : function(reasonForDiscount){
	     			if(reasonForDiscount){
	     			    return reasonForDiscount;
	     			}
	     		}
	         }]
});