/**
 * @author Dharmendra.prajapati
 * 
 */
var templateFor = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"ACTIVE_STUDENT", "name":getCommonTranslation("BULK_BILL_ACTIVE_STUDENT")},
        {"value":"INACTIVE_STUDENT", "name":getCommonTranslation("BULK_BILL_INACTIVE_STUDENT")},
        {"value":"APPLICANT", "name":getCommonTranslation("BULK_BILL_APPLICANT")}] 
});

Ext.define('Academia.view.feeandpayment.managebill.BillDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.billdownloadform',
	//plugins : "formlabelrequired",
	frame: false,
	cls:'billDowunloadFormCls',
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
	/*layout : {
		type : 'vbox'
	},*/
	/*defaults : {
		labelAlign : 'top',
		width: 256,
		margin: 0
	},*/
	items : [{
		xtype:'fieldcontainer',
		items:[{
			 xtype : 'radiogroup',
			 itemId:'billTypeRadioGroupItemId',
				defaults: {
					flex: .1
				},
			 items : [{
				 boxLabel : getCommonTranslation('BILL_RECEIVABLE'),
				 name : 'billTypeRadioOption',
				 inputValue : 'forBillReceivable',
				 checked : true
			 },{
				 boxLabel : getCommonTranslation('BILL_PAYABLE'),
				 name : 'billTypeRadioOption',
				 inputValue : 'forBillPayable'
			 }]
			},{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 380
			},
			items : [{
				 xtype : 'customcombobox',
        		 name : 'templateFor',
        		 itemId:'templateFor',
        		 fieldLabel : getCommonTranslation('TEMPLATE_FOR'),
        		 store:templateFor,
        		 valueField : 'value',
        		 displayField : 'name',
        		 value:'ACTIVE_STUDENT',
        		 editable:false
			},{
				 xtype : 'customcombobox',
        		 name : 'academyLocation',
        		 itemId:'academyLocation',
        		 fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
        		 store:'common.AcademyLocationNameSeparated',
        		 valueField : 'id',
        		 displayField : 'value',
        		 allowBlank : false,
        		 forceSelection:true,
        		 hideTrigger:false,
        		 typeAhead:true,
        		 triggerAction: 'all',
        		 minChars:3,
        		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		 queryParam:'qry',
        		 listConfig: {
 					listeners: {
 						beforeshow: function(picker) {
 							//picker.minWidth = picker.up('combobox').getSize().width;
 							var combo = picker.up('combobox');
 							picker.setWidth(combo.getWidth());
 						}
 					}
 				}
			}]
		}]},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			height:'auto',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 380
				},
			items: [{
				xtype: 'multiselectcombofield',
			    name: 'program',
			    itemId:'program',
			    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			    store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			    valueField: 'id',
			    displayField: 'valueCode',
			    allowBlank: false,
			    typeAhead:true,
			    forceSelection:true,
			    hideTrigger:false,
			    typeAhead:true,
			    triggerAction: 'all',
			    minChars:3,
	            queryParam:'programName',
	            maxLength:50000,
	            cls:'ProgramCourseMultiselectField',
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							//picker.minWidth = picker.up('combobox').getSize().width;
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
				
			},{
				xtype: 'multiselectcombofield',
			    name: 'batch',
			    itemId:'batch',
			    fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			    store: 'common.ProgramBatchStore',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: false,
			    typeAhead:true,
			    maxLength:50000,
			    forceSelection:true,
			    disabled:true,
			    cls:'ProgramCourseMultiselectField',
			},{		
				xtype: 'multiselectcombofield',
				name: 'seatType',
			    itemId:'seatType',
			    fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			    store: 'enquiry.ProgramBatchSeatTypeStore',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: false,
			    typeAhead:true,
			    maxLength:80000,
			    forceSelection:true,
			    autoloadStore: false,
			    delimiter:null,
			    disabled:true,
			    cls:'ProgramCourseMultiselectField',
			}]}
		]},
			{
				xtype: 'fieldcontainer',
				layout : 'hbox',
			 	width: '100%',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
			items: [{
				xtype: 'checkboxfield',
		        width: 'auto',
		        labelAlign: 'right',
		        style:{
		        	marginTop:'25px'
		        },
		        itemId:'whetherInactiveStudent',
		        boxLabel: getFeeAndPaymentCommonTranslation('ONLY_INACTIVE_STUDENTS'),
		        name: 'whetherInactiveStudent',
		        inputValue : true,
		        uncheckedValue: false,
		        hidden:true  //not in use

			}]},{
				xtype:'fieldcontainer',
				layout : 'hbox',
				margin:'0 0 0 -22',
				cls: 'customSearchPanelBtnsFieldContainerCls',
				items:[{
		           	 xtype: 'button',
		        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
		             itemId: 'downoladBtnId',
		             hidden:false,
		             ui: 'CustomBtnSubmit',
		             formBind:true
		        },{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                //buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
			}]
});
