/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.BillHeaderGridForSponsor', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.billheadergridforsponsor',
	store : 'feeandpayment.managebill.BillHeaderForSponsor',
	title: getFeeAndPaymentCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managebillstructure':1
		}
	},
	viewConfig : {
		getRowClass: function (record, rowIndex, rowParams, store) {
	           return (record.get('academyName') == 'Total('+record.data.billNo+')') ? 'gridPaymentGrid' : '';
	       },
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store:'feeandpayment.managebill.BillHeaderForSponsor',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		/*xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH*/
		xtype: 'button',
		itemId: 'btnDelete',
		text: getCommonTranslation('CANCEL'),
		cls: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
        itemId: 'btnSendInvoice',
        text: getFeeAndPaymentCommonTranslation('SEND_INVOICE'),
        cls: 'CustomBtnCancel',
        disabled:true,
        scale: CONSTANTS.BUTTONSIZE,
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('Change_Bill_Due_Date'),
			itemId:'changeDueDate'	
		},{
			text:getFeeAndPaymentCommonTranslation('LABEL'),
			itemId:'flaggedUnflagged',
			disabled:true
		}],
		listeners: { click: function() { this.showMenu(); } }
	},{
		xtype: 'button',
		itemId: 'btnPrint',
		 disabled:true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],

	columns : [{
		header:getCommonTranslation('ID'),
		dataIndex:'billNo',
		flex : 1,
		summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0){
				
							return getFeeAndPaymentCommonTranslation('Total(In '+store.data.items[0].data.acadCurrencyName+')');
			}
			else{

				return getFeeAndPaymentCommonTranslation('Total');
			}
		}
	},{
		header : getCommonTranslation('TYPE'),
		dataIndex : 'raiseBillType',
		flex : 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('CATEGORY'),
		dataIndex:'raiseBillCategory',
		flex : 1,
		hidden:true,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header:getCommonTranslation('GENERATION_TYPE'),
		dataIndex:'billGenerationType',
		flex : 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header:getCommonTranslation('NAME'),
		dataIndex:'name',
		flex : 1
    },{
    	header : getCommonTranslation('FIRST_NAME'),
    	dataIndex : 'personFirstName',
    	hidden:true,
    	flex:1
    },{
    	header : getCommonTranslation('MIDDLE_NAME'),
    	dataIndex : 'personMiddleName',
    	hidden:true,
    	flex:1
    },{
    	header : getCommonTranslation('LAST_NAME'),
    	dataIndex : 'personLastName',
    	hidden:true,
    	flex:1
    },
    {
		header: getCommonTranslation('FEE_PLAN_NAME'),
		dataIndex:'feePlanName',
		flex : 1
	},{
		header:getCommonTranslation('DATE'),
		dataIndex:'billingDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:getCommonTranslation('DUE_DATE'),
		dataIndex:'dueDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:getCommonTranslation('CURRENCY'),
		dataIndex:'currencyName',
		flex : 1
	},{
		header:getCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex:'settlementBillStatus',
		flex : 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},
	{
		header: getCommonTranslation('CANCELLATION_DATE'),
		dataIndex:'cancellationDate',
		flex : 1,
		hidden:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},
	{
		//header : getHostelTranslation('CANCELLATION_REASON'),
		header : getCommonTranslation('CANCELLATION_REASON'),
		dataIndex : 'cancellationNarration',
		flex : 2,
		hidden:true
	},{
		header:getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex:'grossAmount',
		flex : 1.8,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
	
	},{

  		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
  		dataIndex : 'currencyExchangeRate',
  		flex : 1.2,
  		
     },{
		header:getCommonTranslation('CONCESSION_AMOUNT'),
		dataIndex:'concessionAmount',
		flex : 1.8,
		hidden:true,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
     
     	},{
		header:getCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex:'discountAmount',
		flex : 1.8,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
     	
	},{
		header:getCommonTranslation('NET_AMOUNT'),
		dataIndex:'netAmount',
		flex : 1.8,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
	
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programNameToBePrinted',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex:'batchName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex:'studentCode',
		flex : 1,
		hidden:true
	},{
		header:getCommonTranslation('SPONSOR_NAME'),
		dataIndex:'sponsorName',
		flex : 1,
		hidden:true
	},{
	//	header:getServiceRequestTranslation('FEE_PLAN_RULE_STAGE'),
		header:getCommonTranslation('FEE_PLAN_RULE_STAGE'),
		dataIndex:'billFeePlanRuleStageId',
		flex : 1,
		hidden:true
	},{
		header:getCommonTranslation('BILLED_USER_TYPE'),
		dataIndex:'billedUserType',
		flex : 1,
		hidden:true
	},{
	
		header:getCommonTranslation('STATUS'),
		dataIndex:'billStatus',
		flex : 1,
		hidden:true
		
	},{
		header:getCommonTranslation('BILL_ABLE_AMOUNT'),
		dataIndex:'billableAmount',
		flex : 1.8,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)&&store.data.items[0].data.acadLocBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
			
		}
		
		
		/*renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}*/
	
		
	},
	{
    	 header : getCommonTranslation('CONVERTED_AMOUNT'),
  		dataIndex : 'convertedBillableAmount',
  		flex : 1.2,
  		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(value==0.0)
					return "-";
				return currencyRenderer(value,record.get("acadLocBaseCurrencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(store.data.items[0].data.acadLocBaseCurrencyId)){
				return currencyRenderer(value,store.data.items[0].data.acadLocBaseCurrencyId);
			}
			else{

				return '';
			}
		}
    },
    {
		header : getCommonTranslation('ADJUSTMENT_DETAILS'),
		dataIndex : 'adjustmentDetails',
		flex : 1,
		renderer : function(value){
			return  '<a href="#">'+"View"+'</a>';
		}
	},
	{
		header : getCommonTranslation('LABEL_NAME'),
		dataIndex:'labelName',
		flex : 1,
		hidden:true
	},
	{
		header : getCommonTranslation('LABEL_COMMENT'),
		dataIndex:'labelComment',
		flex : 1,
		hidden:true,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
		    // Handle null or empty value
		    if (val === null || val === '') {
		        rec.tdCls = 'gridInputCustomStyle'; 
		        
		    } else {
		        // Truncate long values and apply tooltip
		        if (val.length > 100) {
		            var valtext = val.substring(0, 70) + "...";
		            rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		            return valtext;
		        } else {
		            // Apply tooltip and custom CSS class for other values
		            rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		            rec.tdCls = "assign-remark-column-cls"; 
		            return val;
		        }
		    }
		}
	}]

});