/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.BillServiceReceivedWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.billservicereceivedwindow',
	title:getFeeAndPaymentCommonTranslation('BILL_SERVICE_RECEIVED'),
	frame: true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '0 0 0 0',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			    xtype:'hidden',
			    name:'id'
		    },{
				xtype: 'customcombobox',
				name: 'serviceReceived',
				itemId:'serviceReceived',
				fieldLabel: getFeeAndPaymentCommonTranslation('SERVICE_RECEIVED_NAME'),
				store:'feeandpayment.managebill.ServiceReceived',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				typeAhead:true
			},{
				xtype: 'numberfield',
				name: 'feeAmount',
				itemId:'feeAmount',
				minValue:0,
				hideTrigger:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('SERVICE_AMOUNT'),
				allowBlank:false,
				readOnly:true
		
		     },{
		    	xtype: 'numberfield',
				name: 'noOfSession',
				itemId:'noOfSession',
				minValue:0,
				hideTrigger:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU_SERVICE_AMOUNT'),
				allowBlank:false 
			    },{
			    xtype: 'numberfield',
				name: 'noOfSession',
				itemId:'noOfSession',
				minValue:0,
				hideTrigger:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_SESSION'),
				allowBlank:false
				},{
				xtype: 'fieldcontainer',
				//width:'100%',
				//cls:'windowBtnPos',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind: true
				},{
					xtype: 'button',
					text: getCommonTranslation('CANCEL'),
					itemId: 'CancelBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
		     }]
	    }]     
});