/**
 * @author Deepak Nigam
 */
var templateFor = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
    	 {"value":"ACTIVE_STUDENT", "name":getCommonTranslation("BULK_BILL_ACTIVE_STUDENT")},
         {"value":"INACTIVE_STUDENT", "name":getCommonTranslation("BULK_BILL_INACTIVE_STUDENT")},
         {"value":"APPLICANT", "name":getCommonTranslation("BULK_BILL_APPLICANT")}] 
});
Ext.define('Academia.view.feeandpayment.managebill.BillUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.billuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	//cls:'customSearchPanel',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'billUploadOptionRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype : 'customcombobox',
			name : 'templateForUpload',
			itemId:'templateForUpload',
			fieldLabel : getCommonTranslation('TEMPLATE_FOR'),
			store:templateFor,
			valueField : 'value',
			displayField : 'name',
			value:'ACTIVE_STUDENT',
			editable:false
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleName',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			readOnly:true,
			hidden:true, 
		},{
			xtype: 'checkboxfield',
	        width: 'auto',
	        labelAlign: 'right',
	        style:{
	        	marginTop:'25px'
	        },
	        itemId:'whetherInactiveStudent',
	        boxLabel: getFeeAndPaymentCommonTranslation('INACTIVE_STUDENTS'),
	        name: 'whetherInactiveStudent',
	        inputValue : true,
	        uncheckedValue: false,
	        hidden:true  
		}]
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		margin:'0 0 0 -22',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
