/**
 * @author Pragati Laad
 * 
 */
Ext.define('Academia.view.feeandpayment.managebill.BulkDiscountDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.bulkdiscountdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				 xtype : 'customcombobox',
        		 name : 'academyLocation',
        		 itemId:'academyLocationDiscountID',
        		 width: 536,
        		 fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
        		 store:'common.AcademyLocationNameSeparated',
        		 valueField : 'id',
        		 displayField : 'value',
        		 allowBlank : false,
        		 forceSelection:true,
        		 hideTrigger:false,
        		 typeAhead:true,
        		 triggerAction: 'all',
        		 minChars:3,
        		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		 queryParam:'qry'
			}]
		}]},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				defaults: {
					labelAlign: 'top'
				},
			items: [{
				xtype: 'multiselectcombofield',
			    name: 'program',
			    itemId:'programDiscountItemId',
			    width: 536,
			    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			    store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			    valueField: 'id',
			    displayField: 'valueCode',
			    allowBlank: true,
			    typeAhead:true,
			    forceSelection:true,
			    hideTrigger:false,
			    typeAhead:true,
			    triggerAction: 'all',
			    minChars:3,
	            queryParam:'programName',
	            maxLength:50000,
	            cls:'receiptHeaderMultiselect',
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
			    name: 'batch',
			    itemId:'batchDiscountItemId',
			    fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			    width: 536,
			    store: 'common.ProgramBatchStore',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: true,
			    typeAhead:true,
			    maxLength:50000,
			    forceSelection:true,
			    disabled:true,
			    cls:'receiptHeaderMultiselect'
			}]}
		]},
			{
				xtype: 'fieldcontainer',
				layout : 'hbox',
			 	width: '100%',
				defaults: {
					labelAlign: 'top',
				},
			items: [{		
				xtype: 'multiselectcombofield',
				name: 'seatType',
			    itemId:'seatTypeDiscountItemId',
			    fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			    width: 536,
			    store: 'enquiry.ProgramBatchSeatTypeStore',
			    valueField: 'id',
			    displayField: 'value',
			    allowBlank: true,
			    typeAhead:true,
			    maxLength:80000,
			    forceSelection:true,
			    autoloadStore: false,
			    delimiter:null,
			    disabled:true,
			    cls:'receiptHeaderMultiselect'
			}]},
			{
				xtype: 'fieldcontainer',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
			items: [{
				xtype: 'datefield',
				name: 'billDateForm',
				itemId:'billDateForm',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				endDateField: 'billDateTill',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_FORM')
			},{
				xtype: 'datefield',
				name: 'billDateTill',
				itemId:'billDateTill',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype: 'daterange',
				startDateField: 'billDateForm',
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_TILL')
			}]
			},{
				xtype:'fieldcontainer',
				layout : 'hbox',
				cls: 'customSearchPanelBtnsFieldContainerCls',
				items:[{
		           	 xtype: 'button',
		        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
		             itemId: 'downoladBtnId',
		             hidden:false,
		             ui: 'CustomBtnSubmit',
		             formBind:true
		        },{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                //buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
			}]
});
