/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.feeandpayment.payment.FeePayerDetailsFormParent', {
    //extend: 'Ext.form.Panel',
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.feepayerdetailsformparent',
	layout:'vbox',
	 border: false,
	    frame: false,
	    style:{
			marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
		},
	    plugins: "formlabelrequired",
	    items: [{
	        xtype: 'hidden',
	        name: 'module',
	        value: 'FeePayerDetail'
	    }, {
	        xtype: 'hidden',
	        name: 'feePayerIdUploadPath'
	    }, {
	        xtype: 'hidden',
	        name: 'feePayerProofOfAccountUploadPath'
	    }, {
	        xtype: 'hidden',
	        name: 'feePayerLatestPayslipUploadPath'
	    }, {
	        xtype: 'hidden',
	        itemId: 'idItemId',
	        name: 'id'
	    },  {
	        xtype: 'hidden',
	        itemId: 'documentIdItemId',
	        name: 'documentId'
	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            width: 321
	        },
	        layout: 'hbox',
	        items: [{
	            xtype: 'fieldcontainer',
	            width: 'auto',
	            layout: 'vbox',
	            defaults: {
	                labelAlign: 'top',
	            },
	            items: [{
	                xtype: 'radiogroup',
	                itemId: 'payerTypeItemId',
	                name:'payerTypeItemId',
	                fieldLabel: getPersonModuleTranslation('FPD_PAYER_TYPE'),
	                width: 355,
	                height: 65,
	                style: {
	                    marginTop: '5px'
	                },
	                defaults: {
	                    flex: .1
	                },
	                items: [{
	                    boxLabel: getPersonModuleTranslation('FPD_PERSON'),
	                    name: 'payerType',
	                    inputValue: 'PERSON',
	                    checked: true

	                }, {
	                    boxLabel: getPersonModuleTranslation('FPD_CORPORATE'),
	                    name: 'payerType',
	                    inputValue: 'CORPORATE'
	                },{
	                    boxLabel: getPersonModuleTranslation('FPD_STUDENT'),
	                    name: 'payerType',
	                    hidden: true,
	                    inputValue: 'STUDENT'

	                }]
	            }]
	        },
	        {
	            xtype: 'fieldcontainer',
	            width: 'auto',
	            layout: 'hbox',
	            itemId: 'empOfTheOrgContainerItemId',
	            defaults: {
	                labelAlign: 'top',
	            },
	            items: [{
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                layout: 'vbox',
	                defaults: {
	                    labelAlign: 'top',
	                },
	                items: [/*{
	                    xtype: 'label',
	                    itemId: 'empOfTheOrgLabelItemId',
	                    text: getPersonModuleTranslation('FPD_EMPLOYEE_OF_THE_ORGANIZATION'),
	                    style: {
	                        marginTop: '5px'
	                    },
	                    width: 256
	                },*/ {
	                    xtype: 'radiogroup',
	                    itemId: 'empOfTheOrgItemId',
	                    name:'empOfTheOrgItemId',
	                    fieldLabel: getPersonModuleTranslation('FPD_EMPLOYEE_OF_THE_ORGANIZATION'),
	                    width: 230,
	                    height: 65,
	                    defaults: {
	                        flex: .1
	                    },
	                    items: [{
	            			boxLabel: getPersonModuleTranslation('YES'),
	            			itemId: 'employeeOfOrganizationyes',
	            			name: 'employeeOfOrganization',
	            			inputValue: true
	            		//	checked: true
	            		}, {
	            			boxLabel: getPersonModuleTranslation('NO'),
	            			itemId: 'employeeOfOrganizationno',
	            			name: 'employeeOfOrganization',
	            			inputValue: false,
	            			checked: true
	            		}]
	                }]
	            }, {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                layout: 'vbox',
	                defaults: {
	                    labelAlign: 'top',
	                },
	                items: [/*{
	                    xtype: 'label',
	                    text: getPersonModuleTranslation('FPD_EMPLOYEE_ID'),
	                    style: {
	                        marginTop: '5px'
	                    },
	                    width: 256
	                },*/ {
	                    xtype: 'textfield',
	                    name: 'employeeId',
	                    itemId: 'employeeIdItemId',
	                    fieldLabel: getPersonModuleTranslation('FPD_EMPLOYEE_ID'),
	                    hidden:true,
	                    maxLength: 100,
	                    labelStyle: 'margin-top: 4px;'
	                }]
	            }]
	        }]
	    }, {
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'hbox',
	    	defaults: {    	
	    		width: 700    		
	    	},
	    	items: [{
				xtype: 'checkboxfield',
				itemId : 'primaryFeePayerId',
				labelAlign: 'right',
				boxLabel: getPersonModuleTranslation('PRIMARY_FEE_PAYER'),
				name: 'isPrimaryFeePayer',
				hidden : true,
				inputValue: true,
				uncheckedValue: false
			}]
	    
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        layout: 'hbox',
	        items: [{
	            xtype: 'nestedJsonCombo',
	            fieldLabel: getPersonModuleTranslation('FPD_SALUTATION'),
	            itemId: 'salutationItemId',
	            name: 'salutationId',
	            store: 'common.SalutationStore',
	            valueField: 'id',
	            displayField: 'salutationName',
	            queryMode: 'local',
	            allowBlank: false,
	            editable: false
	        }]

	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        layout: 'hbox',
	        items: [{
	            xtype: 'textfield',
	            name: 'firstName',
	            itemId: 'firstNameItemId',
	            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
	            allowBlank: false,
	            maxLength: 100
	        }, {
	            xtype: 'textfield',
	            name: 'middleName',
	            itemId: 'middleNameItemId',
	            fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
	            maxLength: 53
	        }, {
	            xtype: 'textfield',
	            name: 'lastName',
	            itemId: 'lastNameItemId',
	            fieldLabel: getPersonModuleTranslation('LAST_NAME'),
	            allowBlank: false,
	            maxLength: 100
	        }]
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        layout: 'hbox',
	        items: [{
	            xtype: 'textfield',
	            name: 'occupation',
	            itemId: 'occupationItemId',
	            fieldLabel: getPersonModuleTranslation('OCCUPATION'),
	            allowBlank: true,
	            hidden: true,
	            maxLength: 100
	        }, {
	            xtype: 'textfield',
	            name: 'employerCompanyName',
	            itemId: 'employerCompanyNameItemId',
	            fieldLabel: getPersonModuleTranslation('EMPLOYER_COMPANY_NAME'),
	            hidden: true,
	            maxLength: 53
	        }, {
	            xtype: 'textfield',
	            name: 'employerEmail',
	            itemId: 'employerEmailItemId',
	            vtype: 'email',
	            fieldLabel: getPersonModuleTranslation('EMPLOYER_EMAIL_ID'),
	            allowBlank: true,
	            hidden: true,
	            maxLength: 100
	        }]
	    },{
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'hbox',
	    	defaults: {
	    		labelAlign: 'top',
	    		width: 256
	    	},
	    	items: [{
	            xtype: 'textfield',
	            name: 'companyName',
	            itemId: 'companyNameItemId',
	            fieldLabel: getPersonModuleTranslation('FPD_NAME_OF_COMPANY'),
//	            allowBlank: false,
	            hidden: true,
	            maxLength: 255
	        }, {
	            xtype: 'textfield',
	            name: 'contactPerson',
	            itemId: 'contactPersonItemId',
	            fieldLabel: getPersonModuleTranslation('FPD_NAME_OF_CONTACT_PERSON'),
	            hidden: true,
//	            allowBlank: false,
	            maxLength: 255
	        }, {
	            xtype: 'textfield',
	            name: 'surname',
	            itemId: 'surnameItemId',
	            fieldLabel: getPersonModuleTranslation('FPD_SURNAME'),
	            hidden: true,
	            allowBlank: true,
	            maxLength: 255
	        }]
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: 'vbox',
	        hidden: true,
	        defaults: {
	            labelAlign: 'top',
	        },
	        items: [{
	            xtype: 'radiogroup',
	            itemId: 'doesFeePayerConsentToCreditCheckItemId',
	            fieldLabel: getPersonModuleTranslation('FPD_DOES_FEE_PAYER_CONSENT_TO_CREDIT_CHECK'),
	            width: 230,
	            height: 65,
	            style: {
	                marginTop: '5px'
	            },
	            defaults: {
	                flex: .1
	            },
	            items: [{
	                boxLabel: getPersonModuleTranslation('YES'),
	                name: 'doesFeePayerConsentToCreditCheck',
	                inputValue: true
	            }, {
	                boxLabel: getPersonModuleTranslation('NO'),
	                name: 'doesFeePayerConsentToCreditCheck',
	                inputValue: false,
	                checked: true
	            }]
	        }]
	    }, {
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'vbox',
	    	name:'addressDetailsLabel',
	    	itemId: 'addressDetailsLabelItemId',
	    	fieldLabel: getPersonModuleTranslation('FEE_PAYER_ADDRESS'),
	    	labelStyle: 'width: 250px;color: #000000;text-decoration: underline;font-weight: bold;',
	    	items: []
	    },{
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'vbox',
	    	itemId: 'addressDetailItemId',
	    	height: 40,
	    	width: 'auto', 
	    	defaults: {
	    		labelAlign: 'top',
	    		width: 700    		
	    	},
	    	items: [{
				xtype: 'checkboxfield',
				itemId : 'isSameAsCurrentAddress',
				labelAlign: 'right',
				region: 'south',
				boxLabel: getPersonModuleTranslation('SAME_AS_APPLICANT_CURRENT_ADRESS'),
				name: 'isSameAsCurrentAddress',
				inputValue: true,
				uncheckedValue: false
			}]
	    
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        itemId:'addressContainerItemId',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        style: {
	            //marginTop: '20px',
	        },
	        layout: 'vbox',
	        items: [{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'hbox',
	        items: [{
	    		xtype : 'textareafield',
	    		fieldLabel : getCommonTranslation('ADDRESS'),
	    		name : 'addressTextArea',
	    		itemId : 'addressTextArea',
                allowBlank: false,
	    		width: 536,
	    		maxLength:255,
	    		listener:{
	    			blur:function(){}
	    		}
	    	}]
	        },{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'hbox',
	            items: [{
	        		xtype : 'customcombobox',
	        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
	        		hiddenName : 'countryId',
	        		itemId : 'countryId',
	        		store:'common.CountryStore',
	        		valueField : 'id',
	        		displayField : 'countryName',
	        		name : 'countryId',
	    			queryParam:'countryName',   		        						
					forceSelection :true,
					typeAhead : false,
					allowBlank: false,
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					hideTrigger:false,
					listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{countryName}'  +
			                    '</div>';
			                }
			            }
	        	}, {
	        		xtype : 'customcombobox',
	        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
	        		itemId : 'parentCountryRegionId',
	        		store:'organization.CountryRegionStore',
	        		valueField : 'id',
	        		displayField : 'countryRegionName',
	        		name : 'parentCountryRegionId',
	    			queryParam:'regionName',   		 
					forceSelection :true,
					typeAhead : false,
					allowBlank: false,
					hideTrigger:false,
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{countryRegionName}'  +
			                    '</div>';
			                }
			            }
	        	
	            }]
	        },{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'hbox',
	            items: [{
	        		xtype : 'customcombobox',
	        		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
	        		hiddenName : 'cityId',
	        		itemId : 'cityId',
	        		store:'organization.CityByCountryOrRegion',
	        		valueField : 'id',
	        		displayField : 'value',
	        		name : 'cityId',
	    			queryParam: 'cityName',
                    allowBlank: false,   		 
	    			forceSelection :true,
	    			typeAhead : false,
	    			minChars:3,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			listConfig: {
	    				  listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	                loadingText: getCommonTranslation('SEARCHING'),
	    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	                getInnerTpl: function() {
	    	                    return '<div class="search-item">' +
	    	                    '{value}'  +
	    	                    '</div>';
	    	                }
	    	            }
	        	},{
	        		xtype : 'textfield',
	        		fieldLabel : getCommonTranslation('PINCODE'),
	        		itemId : 'pincodeId',
	        		name : 'pincode',
                    allowBlank: false,
	        		minValue : 0,
	        		maxLength: 8,
	        		maskRe:/^[a-zA-Z0-9\s]+$/          	 
	        	},{
	        		xtype : 'textfield',
	        		fieldLabel : getCommonTranslation('CORPORATE_ID'),
	        		itemId : 'corporateId',
	        		name : 'corporateId',
	        		hidden: true,
	        		maskRe:/^[a-zA-Z0-9\s]+$/          	 
	        	}]
	        
	        }]
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            labelWidth: 93,
	            width: 228,
	            height: 60
	        },
	        layout: 'hbox',
	        items: [
	        	{
				xtype: 'fieldcontainer',
				itemId : 'homeTelephoneContainerItemId',
				fieldLabel: getPersonModuleTranslation('FPD_HOME_TELEPHONE'),
				//allowBlank: false,
				defaults: {
		    		labelAlign: 'top',
		    		width: 228
		    	},
				layout : {
					type : 'hbox'
				},
				items : [{
		            xtype: 'customcombobox',
		            name: 'homeTelephoneCountryCode',
		            itemId: 'homeTelephoneCountryCodeItemId',
		            valueField: 'isdCode',
		            displayField: 'isdCode',
		            store: 'common.CountryStore',
		            //fieldLabel:  getPersonModuleTranslation('FPD_HOME_TELEPHONE_COUNTRY_CODE'),
		           // fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),            
		            triggerAction: 'all',
		            //editable: false,
		            forceSelection: true,
					minChars: 1,
		            //allowBlank: true,
		            width: 66,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }, {
		            xtype: 'numberfield',
		            name: 'homeTelephone',
		            itemId: 'homeTelephoneItemId',
		            //fieldLabel: getPersonModuleTranslation('FPD_HOME_TELEPHONE'),
		            minLength: 0,
		            maxLength: 11,
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            //allowBlank: false,
		            width: 151,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }]
			}, {
				xtype: 'fieldcontainer',
				itemId : 'workTelephoneContainerItemId',
				fieldLabel: getPersonModuleTranslation('FPD_WORK_TELEPHONE'),
				defaults: {
		    		labelAlign: 'top',
		    		width: 228
		    	},
				layout : {
					type : 'hbox'
				},
				items : [{
		            xtype: 'customcombobox',
		            name: 'workTelephoneCountryCode',
		            itemId: 'workTelephoneCountryCodeItemId',
		            valueField: 'isdCode',
		            displayField: 'isdCode',
		            //fieldLabel:  getPersonModuleTranslation('FPD_WORK_TELEPHONE_COUNTRY_CODE'),
		            //fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),
		            store: 'common.CountryStore',
		            triggerAction: 'all',
		            //editable: false,
		            forceSelection: true,
					minChars: 1,
		            allowBlank: true,
		            width: 66,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }, {
		            xtype: 'numberfield',
		            name: 'workTelephone',
		            itemId: 'workTelephoneItemId',
		            minLength: 0,
		            maxLength: 11,
		            //fieldLabel: getPersonModuleTranslation('FPD_WORK_TELEPHONE'),
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            allowBlank: true,
		            width: 151,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }]
			}, {
				xtype: 'fieldcontainer',
				itemId : 'mobileNoFldItemId',
				fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER'),
				allowBlank: false,
				defaults: {
		    		labelAlign: 'top',
		    		width: 228
		    	},
				layout : {
					type : 'hbox'
				},
				items : [{
		            xtype: 'customcombobox',
		            name: 'countryCode',
		            itemId: 'countryCodeItemId',
		            valueField: 'isdCode',
		            displayField: 'isdCode',
		            //fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER_COUNTRY_CODE'),
		            //fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),
		            store: 'common.CountryStore',
		            triggerAction: 'all',
		            //editable: false,
		            forceSelection: true,
					minChars: 1,
//		            allowBlank: false,
		            width: 66,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }, {
		            xtype: 'numberfield',
		            name: 'mobileNumber',
		            itemId: 'mobileNumberItemId',
		            minLength: 0,
		            maxLength: 11,
		            //fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER'),
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            allowBlank: false,
		            width: 151,
		            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
		        }]
			}
			]
	    }, 
	    {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        style: {
	            marginTop: '20px',
	        },
	        layout: 'hbox',
	        items: [{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            itemId: 'nationalAlternateIdContainer',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'vbox',
	            items: [{
	                xtype: 'textfield',
	                fieldLabel: getPersonModuleTranslation('FPD_NATIONAL_ALTERNATE_ID'),
	                name: 'nationalAlternateId',
	                itemId: 'nationalAlternateIdItemId',
	                //allowBlank: false, In DFR field is also optional
	                maxLength: 50,
	                vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
	            }]
	        },{
	            xtype: 'fieldcontainer',
	            itemId: 'emailHomeContainerItemId',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'vbox',
	            items: [{
	                xtype: 'textfield',
	                fieldLabel: getPersonModuleTranslation('FPD_EMAIL_HOME'),
	                name: 'emailHome',
	                vtype: 'email',
	                itemId: 'emailHomeItemId',
	                allowBlank: false,
	                maxLength: 100,
	                listeners:{
	                	blur:function(cmp){
	                		var form = cmp.up();
	                		if(form && form.down('#emailHomeUseForCommunicationItemId')){
	                			form.down('#emailHomeUseForCommunicationItemId').setValue(true);
	                		}
	                	}
	                }
	            }, {
	                xtype: 'checkboxfield',
	                name: 'emailHomeUseForCommunication',
	                itemId: 'emailHomeUseForCommunicationItemId',
	                boxLabel: getPersonModuleTranslation('FPD_USE_THIS_FOR_COMMUNICATION'),
	                width: 'auto',
	                labelAlign: 'right',
	                style: {
	                    marginTop: '5px',
	                    whiteSpace: 'nowrap',
	                },
	                inputValue: true,
	                uncheckedValue: false
	            }]
	        }, {
	            xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'vbox',
	            items: [{
	                xtype: 'textfield',
	                fieldLabel: getPersonModuleTranslation('FPD_EMAIL_WORK'),
	                name: 'emailWork',
	                vtype: 'email',
	                itemId: 'emailWorkItemId',
	                maxLength: 100,
	                style: {
	                	marginLeft: '5px',
	                }
	            }, {
	                xtype: 'checkboxfield',
	                name: 'emailWorkUseForCommunication',
	                itemId: 'emailWorkUseForCommunicationItemId',
	                boxLabel: getPersonModuleTranslation('FPD_USE_THIS_FOR_COMMUNICATION'),
	                width: 'auto',
	                labelAlign: 'right',
	                style: {
	                	marginTop: '5px',
	                	whiteSpace: 'nowrap',
	                },
	                inputValue: true,
	                uncheckedValue: false
	            }]
	        }, {
	            xtype: 'fieldcontainer',
	            itemId: 'companyAddressContainerItemId',
	            width: 'auto',
	            height: 100,  
	            hidden: true,
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'vbox',
	            items: [{
	                xtype: 'textareafield',
	                fieldLabel: getPersonModuleTranslation('FPD_COMPANY_ADDRESS'),
	                name: 'companyAddress',
	                itemId: 'companyAddressItemId',
	                maxLength: 255,
	                width: 456                
	            }]
	        }]
	    },{
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'vbox',
	    	itemId: 'paymentOptionDetailsLabelItemId',
	    	fieldLabel: getPersonModuleTranslation('FPD_PAYMENT_OPTION_DETAILS'),
	    	labelStyle: 'width: 250px;color: #000000;text-decoration: underline;font-weight: bold;',
	    	items: []
	    },{
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'vbox',
	    	itemId: 'paymentModeContainerItemId',
	    	height: 65,
	    	defaults: {
	    		labelAlign: 'top',
	    		width: 300    		
	    	},
	    	items: [{
	    		xtype: 'radiogroup',
	    		itemId: 'paymentModeItemId',
	    		name:'paymentModeItemId',
	    		fieldLabel: getPersonModuleTranslation('FPD_PAYMENT_MODE'),
	            allowBlank: true,
	    		style: {
	    			marginTop: '5px'
	    		},
	    		defaults: {
	    			flex: .1
	    		},
	    		items: [{
	    			boxLabel: getPersonModuleTranslation('FPD_EFT'),
	    			name: 'paymentMode',
	                inputValue: 'EFT',
	                checked: true
	    		}, {
	    			boxLabel: getPersonModuleTranslation('FPD_DEBIT_ORDER'),
	    			name: 'paymentMode',
	                inputValue: 'DEBIT_ORDER'    			
	    		}]
	    	}]
	    
	    }, {
			xtype:'fieldcontainer',
			width:'100%',
			layout : 'hbox',
			items: [{
				xtype: 'radiogroup',
				itemId: 'applicableForCurrentYearItemId',
				labelAlign:'top',
				vertical: false,
				allowBlank : false,
				width:'100%',
				hidden : true,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_CURRENT_YEAR'),
					name: 'applicableForCurrentYear',
					inputValue: true,
					hidden :true
					
				},{
					boxLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_NEXT_YEAR'),
					name: 'applicableForCurrentYear',
					inputValue: false,
					checked: true,
					hidden :true
				}]
			}]
	    },{
	    	xtype: 'fieldcontainer',
	    	width: '100%',
	    	layout: 'vbox',
	    	defaults: {
	    		labelAlign: 'top',
	    	},
	    	items: [{
	    		xtype: 'label',
	    		text: getCommonTranslation('DEBIT_ORDER_NOTE_FOR_REGISTRATION_PROCESS_PARENT_PORTAL'),
	    		name:'debitOrderTextMsg',
	    		itemId:'debitOrderTextMsg',
	    		width:'100%',
	    		style: 'color: #000000;font-weight:bold;'

	    	},]
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        itemId:'debitOrderContainerItemId',
	        hidden: true,
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        style: {
	            marginTop: '20px',
	        },
	        layout: 'vbox',
	        items: [{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'hbox',
	        items: [{
	            	xtype: 'customcombobox',
					name: 'debitOrderDate',
					itemId:'debitOrderDateItemId',
					fieldLabel: getPersonModuleTranslation('FPD_DEBIT_ORDER_DATE'),
		//			store: Ext.create('Academia.store.feeandpayment.FeePayerDebitOrderDateStore'),
					valueField: 'id',
					displayField: 'value',
				//	queryMode: 'local',
					typeAhead:true,
					forceSelection:true,
					allowBlank:true,
					  listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.feeandpayment.FeePayerDebitOrderDateStore');
		                         combo.bindStore(store);
		                     }
		                 }
					
	            }, {
	            	xtype: 'customcombobox',
					name: 'accountType',
					itemId:'accountTypeItemId',
					fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_TYPE'),
					store: Ext.create('Academia.store.feeandpayment.FeePayerAccountTypeStore'),
					valueField: 'id',
					displayField: 'value',
					queryMode: 'local',
					typeAhead:true,
					forceSelection:true,
					allowBlank:true
	            }, {
	                xtype: 'textfield',
	                fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_NUMBER'),
	                name: 'accountNumber',
	                itemId: 'accountNumberItemId',
	                minLength: 6,
	            	maxLength: 15,
	                allowBlank: true,
	            }]
	        },{
	        	xtype: 'fieldcontainer',
	            width: 'auto',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
	            layout: 'hbox',
	            items: [{
	                xtype: 'textfield',
	                fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_NAME'),
	                name: 'accountName',
	                itemId: 'accountNameItemId',
	                allowBlank: true,
	                maxLength: 100
	            }, {
	            	xtype: 'customcombobox',
					name: 'bank',
					itemId:'bankItemId',
					fieldLabel: getPersonModuleTranslation('FPD_BANK_NAME'),
					store: Ext.create('Academia.store.feeandpayment.receipts.DrawnOnBank'),
					valueField: 'id',
					displayField: 'value',
					queryMode: 'local',
					typeAhead:true,
					forceSelection:true,
					allowBlank:true
	            }, {
	                xtype: 'customcombobox',
	                fieldLabel: getPersonModuleTranslation('FPD_BRANCH_CODE'),
	                store: Ext.create('Academia.store.personinfo.common.personalinfo.BankBranchCodeStore'),
	                name: 'branchCode',
	                itemId: 'branchCodeItemId',
	                valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
	                allowBlank: true,
	                disabled : true,
	            }]
	        },{
	    		xtype:'fieldcontainer',
	    		layout:'hbox',
	    		width: 'auto',
	    		defaults: {
	    			width: 256,
	    			labelAlign: 'top'
	    		},
	    		items:[{
	    			xtype: 'datefield',
	    			name: 'debitOrderStartDate',
	    			itemId:'debitOrderStartDate',
	    			allowBlank: true,
	    			hidden: true,
	    			listeners: {
	    				render: function(field) {
	    					return dateFormatRender(field);
	    				}
	    			},
	    			//--submitFormat: CONSTANTS.DATE_FORMAT,
	    			vtype: 'daterange',
	    			endDateField: 'debitOrderEndDate',
	    			editable:false,
	    			fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE')
	    		},{
	    			xtype: 'datefield',
	    			name: 'debitOrderEndDate',
	    			allowBlank: true,
	    			hidden: true,
	    			itemId:'debitOrderEndDate',
	    			listeners: {
	    				render: function(field) {
	    					return dateFormatRender(field);
	    				}
	    			},
	    			//--submitFormat: CONSTANTS.DATE_FORMAT,
	    			vtype: 'daterange',
	    			startDateField: 'debitOrderStartDate',
	    			editable:false,
	    			fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE')
	    		}]
	    	}]
	    }, {
	    	xtype: 'fieldcontainer',
	        width: '100%',
	        defaults: {
	            labelAlign: 'top',
	            //width: 256
	        },
	        layout: 'hbox',
	        items: [
	        	{
	                xtype: 'filefield',
	                fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_ID'),
	                buttonText: getPersonModuleTranslation('BROWSE'),
	                itemId: 'feePayerIDItemId',
	                ui: 'CustomBtnSubmit',
	                name: 'feePayerID',
	                width: 256,
	                labelAlign: 'top',
	                allowBlank: false,
	              //  allowBlank:true,
	               // hidden:true,
	                listeners: {
	                    specialkey: function(me, e) {
	                        if (e.getKey() == e.TAB) {
	                            e.stopEvent();
	                        }
	                    }
	                }
	            }, {
	                xtype: 'filefield',
	                fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'),
	                buttonText: getPersonModuleTranslation('BROWSE'),
	                itemId: 'feePayerLatestPayslipItemId',
	                ui: 'CustomBtnSubmit',
	                name: 'feePayerLatestPayslip',
	                width: 256,
	                labelAlign: 'top',
	                //allowBlank: false,
	                //allowBlank:true,
	                //hidden:true,
	                listeners: {
	                    specialkey: function(me, e) {
	                        if (e.getKey() == e.TAB) {
	                            e.stopEvent();
	                        }
	                    }
	                }
	            },{
	    	    	xtype: 'displayfield',
	    	        itemId: 'availableDocumentLabelItemId',
	    	        value: '<a href=#>' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</a>',
	    	       // hidden: true,
	    	        style: {
	    	            marginTop: '24px',
	    	            textDecoration: "underline"
	    	        }
	    		}
	        ]
	    }, {
	        xtype: 'fieldcontainer',
	        items: [{
	            xtype: 'button',
	            text: getCommonTranslation('SUBMIT'),
	            itemId: 'submitButtonId',
	            buttonAlign: 'right',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            text: getCommonTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            hidden:true,
	            scale: CONSTANTS.BUTTONSIZE
	        }]
	    }, {
	        xtype: 'fieldcontainer',
	        items: [{
	            xtype: 'button',
	            text: getCommonTranslation('NEXT'),
	            itemId: 'feePayerDetailNextButon',
	            buttonAlign: 'right',
	            ui: 'CustomBtnSubmit',
	            hidden: true,
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }]
	    }]
});