/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentListForPCAndServiceProvided', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymentlistforpcandserviceprovided',
	title: getCommonTranslation('LIST_OF_PAYMENT'),
	store : 'feeandpayment.payment.PaymentForPCAndServiceProvided',
	border: true,
	refreshStoreData : true,
	isGridConfigurable: true,
	enableColumnHide: false,
	cls:'managePaymentCls',
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'paymentstructure': 1
		}
	},
	viewConfig : {
		getRowClass: function (record, rowIndex, rowParams, store) {/*
			if(record.get('academyName') == 'Total(In '+record.data.currencyName+')'){
				return (record.get('academyName') == 'Total(In '+record.data.currencyName+')') ? 'gridPaymentGrid' : '';
			}
			else{
				return (record.get('academyName') == 'School of Computing EM') ? 'gridPaymentGrid' : '';
			}
		*/},
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow: true
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.PaymentForPCAndServiceProvided',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 2.3,
		summaryRenderer : function(value, summaryData,dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
	      }
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programPrintName',
		flex : 2.3
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1	 
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'personPrintName',
		flex : 1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex:'studentCode',
		flex : 1
	},{
		header : getCommonTranslation('SPONSOR_NAME'),
		dataIndex : 'sponsorName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1
	},{
		header : getCommonTranslation('VOUCHER_MODE'),
		dataIndex : 'voucherMode',
		flex : 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'paymentStatus',
		flex : 1.2,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			metaData.style = "white-space: normal;";
			return getCommonTranslation(value);
		}
	},{
		header : getCommonTranslation('PAYMENT_AMOUNT'),
		dataIndex : 'stdpaymentAmount',
		flex : 1.8,
		summaryType : 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(store.data.items.length>0 && store.data.items[0].data && !isNullOrEmpty(store.data.items[0].data.alBaseCurrencyId)&&store.data.items[0].data.alBaseCurrencyId!=0)
			{
				metaData.column.summaryType='';
			}
			if(!isNullOrEmpty(value)){
            	Ext.util.Format.number(value, '0.00');
				return currencyRenderer(value,record.get("currencyId"));
			}

		}

	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		flex : 1.2
	},
	{
		header : getCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'totalConvertedAmount',
		flex : 2,
		summaryType : 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("alBaseCurrencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(store.data.items.length>0 && store.data.items[0].data && !isNullOrEmpty(store.data.items[0].data.alBaseCurrencyId)){
				return currencyRenderer(value,store.data.items[0].data.alBaseCurrencyId);
			}
			else{
				return '';
			}
		}
	}, {

		header : getCommonTranslation('PAYMENT_DATE'),
		dataIndex : 'transactionDate',
		flex : 1,
		renderer:function(val){	
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('ADJUSTMENT_DETAILS'),
		dataIndex : 'adjustmentDetails',
		flex : 1.4,
		renderer : function(value, metaData, record, row, col, store, gridView){
			if(record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')' || record.get('academyName') == 'Total'){
				return '';
			}
			else{
				if(store.data.items[0].data.currencyId!=null){
					return  '<a href="#">'+"View"+'</a>';
				}
			}

		}
	},{
		header : getCommonTranslation('INSTRUMENT_DETAILS'),
		dataIndex : 'instrumentDetails',
		flex : 1.4,
		renderer : function(value, metaData, record, row, col, store, gridView){
			if(record.data.voucherMode=="BANK"){
				return  '<a href="#">'+"View"+'</a>';
			}else{
				return value;
			}}
	},
	{
		header : getCommonTranslation('COST_CENTER'),
		dataIndex:'costCenterIds',
		hidden:true,
		flex : 1
	}]
});