/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentListForScholarship', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymentlistforscholarship',
	store : 'feeandpayment.payment.PaymentForScholarship',
	isGridConfigurable: true,
	enableColumnHide: false,
	title: getCommonTranslation('LIST_OF_PAYMENT'),
	border: true,
	//autoScroll: true,
	style: {overflowX: 'auto', overflowY: 'hidden'},
	viewConfig : {
		getRowClass: function (record, rowIndex, rowParams, store) {
							if(record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')'){
									 return (record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')') ? 'gridPaymentGrid' : '';
				}
				else{
					 return (record.get('academyName') == 'Total') ? 'gridPaymentGrid' : '';
				}
	       },
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW  
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.payment.PaymentForScholarship',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 2,
		/*summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }*/
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programPrintName',
		flex : 1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1	 
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1	 
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'personPrintName',
		flex : 1
	},{
		header : getCommonTranslation('PAYMENT_VOUCHER_NO'),
		dataIndex : 'paymentVoucherNo',
		flex : 1
	},{
    	 header : getCommonTranslation('VOUCHER_MODE'),
     	 dataIndex : 'voucherMode',
     	 flex : 1,
     	 renderer:function(value){
 			if(value==getFeeAndPaymentCommonTranslation('CASH')){
 				return getCommonTranslation('CASH');
 			}else if(value==getFeeAndPaymentCommonTranslation('BANK')){
 				return getCommonTranslation('BANK');
 			}
 		}
	},{
		header : getCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'paymentStatus',
		flex : 1,
		 renderer:function(value){
				if(value==getFeeAndPaymentCommonTranslation('REVERSED')){
					return getCommonTranslation('REVERSED');
				}else if(value==getFeeAndPaymentCommonTranslation('SETTLED')){
					return getCommonTranslation('SETTLED');
				}else if(value==getFeeAndPaymentCommonTranslation('PARTLY_SETTLED')){
					return getCommonTranslation('PARTLY_SETTLED');
				}else if(value==getFeeAndPaymentCommonTranslation('FULLY_PENDING')){
					return getCommonTranslation('FULLY_PENDING');
				}else if(value==getFeeAndPaymentCommonTranslation('CANCELLED')){
					return getCommonTranslation('CANCELLED');
				}
			}
     },{
    	 header : getCommonTranslation('PAYMENT_AMOUNT'),
     	 dataIndex : 'paymentAmount',
     	 flex : 1,
     /*	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
     },{

 		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
 		dataIndex : 'currencyExchangeRate',
 		flex : 1.2,
 		
   },{
    	 header : getCommonTranslation('CONVERTED_AMOUNT'),
  		dataIndex : 'convertedAmount',
  		flex : 1.2,
    },{
    	 header : getCommonTranslation('PAYMENT_DATE'),
     	 dataIndex : 'transactionDate',
     	 flex : 1,
     	 renderer:function(val){		
			return dateRender(val);
		 }
     },{
    	 header : getCommonTranslation('ADJUSTMENT_DETAILS'),
     	 dataIndex : 'adjustmentDetails',
     	 flex : 1,
    	 renderer : function(value, metaData, record, row, col, store, gridView){
      		if(record.get('academyName') == 'Total(In '+record.data.acadLocBaseCurrency+')' || record.get('academyName') == 'Total'){
 				 return '';
 			}
 			else{
 				if(store.data.items[0].data.currencyId!=null){
 					return  '<a href="#">'+"View"+'</a>';
 				}
 			}
 		}
     },{
    	 header : getCommonTranslation('INSTRUMENT_DETAILS'),
     	 dataIndex : 'instrumentDetails',
     	 flex : 1,
     	 renderer : function(value, metaData, record, row, col, store, gridView){
     	 if(record.data.voucherMode==getFeeAndPaymentCommonTranslation('BANK')){
			  return  '<a href="#">'+"View"+'</a>';
   		 }else{
   			return value;
   		}}
     },
     {
 	 	header : getCommonTranslation('COST_CENTER'),
 	 		dataIndex:'costCenterIds',
 	 		hidden:true,
 	 		flex : 1,
 }]
});