/**
 *  @author Manisha Wagh
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentPlanStatusGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymentplanstatusgrid',
	store : 'feeandpayment.StoPaymentPlanStatusGridStore',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.StoPaymentPlanStatusGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	/* features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	    }],*/
	columns: [{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_NO'),
		dataIndex : 'sequence',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
			return record.data.sequence;
			}                        
			}
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALMENT_AMOUNT'),
		dataIndex : 'amount',
		flex : 2,
		renderer : function(value, metaData, record,
				row, col, store, gridView) {
			if (record.data.status == "Paid") {
				return record.data.amountTobePaid.toFixed(2);
			} else if (record.data.status == "Not Paid"){
				return record.data.amountTobePaid.toFixed(2);
			}
			
		}
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_PAID'),
		dataIndex : 'amountPaidForCurrentSchedule',
		flex : 2,
		renderer : function(value, metaData, record,
				row, col, store, gridView) {
			if (record.data.status == "Paid") {
				return record.data.amountTobePaid.toFixed(2);
			} else if (record.data.status == "Not Paid"){
				return record.data.amountPaidForCurrentSchedule.toFixed(2);
			}
			
		}
	},{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex : 2,
	}
	] 	
});
