/**
 *  @author Prakash.Soni
 */
Ext.define('Academia.view.feeandpayment.payment.PaymentTermSectionList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymenttermsectionlist',
	title : getFeeAndPaymentCommonTranslation('PAYMENT_TERM_SELECTION_PARENT'),
//	store : 'feeandpayment.adjustment.ReceiptAdjustment',
	height:300,
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	dockedItems : [{/*
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.ReceiptAdjustment',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	*/}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('FEE_TYPE'),
		dataIndex : 'receiptNo',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PAYMENT_TERM'),
		dataIndex : 'transactionDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALMENT_PER_MONTH'),
		dataIndex : 'amount',
		flex : 1,
	},{
		header : getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'totalAdjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALMENT_SCHEDULE'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	},
	 /*{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('NEXT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }*/]
});