/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.paymentPlanEnrollment.VWPlanUnEnrolProgramSelectedValueForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.vwplanunenrolprogramselectedvalueform',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [ {
		xtype : 'fieldcontainer',
		 layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
		items : [ {
			xtype: 'hidden',
			name: 'paymentPlanId',
			itemId: 'paymentPlanId',
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
			store:'feeandpayment.paymentPlanEnrollment.StoFnpProgramByPaymentPlanStore',
			valueField: 'id',
			displayField: 'valueCode',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	 
			allowBlank:false,
			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId: 'batchId',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			store: 'enquiry.AcademicBatchStore',
			disabled:true,
			editable: false,
			allowBlank:false,
			displayField: 'value',
			valueField: 'id',
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
			name: 'seatType',
			itemId: 'seatTypeId',
			editable: false,
			disabled:true,
			autoload: false,
			allowBlank:false,
			store: 'enquiry.ProgramBatchSeatTypeStore',
			valueField: 'id',
			displayField: 'value'
		}]
	},{
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		style: {
			'margin-left': '-32px !important;'
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchUnEnrollButtonId',
			formBind: true,
			ui : 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetUnEnrollButtonId',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});