/**
 * @author Makrand Kulkarni 
 */
Ext.define('Academia.view.feeandpayment.receipts.FeeHeadDetailsWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.feeheaddetailswindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '40%',
	width: '80%',
	frame: true,
	title:getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'),
	items : [{
			xtype: 'grid',
			store : 'feeandpayment.receipts.FeeHeadDetails',
			autoScroll: true,
			itemId : 'billHeaderGrid',
			border: true,
			/*viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},*/
			features: [{
				ftype: 'summary',
				showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			/*dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'feeandpayment.receipts.FeeHeadDetails',
					emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],*/
			features: [{
				id: 'group',
				ftype: 'groupingsummary',
				groupHeaderTpl: '{name}',
				hideGroupedHeader: false,
				enableGroupingMenu: false,
				showSummaryRow : false
			}],
			columns: [{
				header : getFeeAndPaymentCommonTranslation('BILL_NO'),
				dataIndex : 'billNo',
				flex : 1/*,
				summaryRenderer: function(value, summaryData, dataIndex) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}*/
			},{
				header : getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'),
				dataIndex : 'feeHeadName',
				flex : 1
			}
			,{
				header : getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
				dataIndex : 'totalAmount',
				flex : 1,
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return currencyRenderer(value,record.get("currencyId"));
					}                    
				} 
			}
			,{
				header : getFeeAndPaymentCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
				dataIndex : 'totalAdjustedAmount',
				flex : 1,
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return currencyRenderer(value,record.get("currencyId"));
					}                    
				} 
			}
			,{
				header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
				dataIndex : 'totalBalanceAmount',
				flex : 1,
				itemId:'totalBalanceAmount',
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return currencyRenderer(value,record.get("currencyId"));
					}                    
				} 
			}] 	

		}]
});
